/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.resource;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.umlx.RelDiagram;
import org.eclipse.qvtd.umlx.RelDomainNode;
import org.eclipse.qvtd.umlx.RelInvocationEdge;
import org.eclipse.qvtd.umlx.RelInvocationNode;
import org.eclipse.qvtd.umlx.RelPatternEdge;
import org.eclipse.qvtd.umlx.RelPatternNode;
import org.eclipse.qvtd.umlx.TxDiagram;
import org.eclipse.qvtd.umlx.TxKeyNode;
import org.eclipse.qvtd.umlx.TxPackageNode;
import org.eclipse.qvtd.umlx.TxParameterNode;
import org.eclipse.qvtd.umlx.TxPartNode;
import org.eclipse.qvtd.umlx.TxQueryNode;
import org.eclipse.qvtd.umlx.TxTypedModelNode;
import org.eclipse.qvtd.umlx.UMLXElement;
import org.eclipse.qvtd.umlx.UMLXModel;
import org.eclipse.qvtd.umlx.UMLXNamedElement;
import org.eclipse.qvtd.umlx.resource.UMLX2XMIid;
import org.eclipse.qvtd.umlx.util.AbstractExtendingUMLXVisitor;
import org.eclipse.qvtd.umlx.utilities.UMLXUtil;

public class UMLX2XMIidVisitor
extends AbstractExtendingUMLXVisitor<Boolean, UMLX2XMIid> {
    public static final int OVERFLOW_LIMIT = 1024;
    public static final @NonNull String OVERFLOW_MARKER = "##";
    public static final @NonNull String NULL_MARKER = "-null-element-";
    public static final @NonNull String DISAMBIGUATION_SEPARATOR = "~";
    public static final @NonNull String FIELD_SEPARATOR = "..";
    public static final @NonNull String FRAGMENT_SEPARATOR = "#";
    public static final @NonNull String OPPOSITE_SEPARATOR = "~";
    public static final @NonNull String SCOPE_SEPARATOR = ".";
    public static final @NonNull String REL_DIAGRAM_PREFIX = "R.";
    public static final @NonNull String REL_DOMAIN_PREFIX = "D.";
    public static final @NonNull String REL_INVOCATION_PREFIX = "V.";
    public static final @NonNull String REL_INVOCATION_EDGE_PREFIX = "A.";
    public static final @NonNull String REL_PATTERN_CLASS_PREFIX = "C.";
    public static final @NonNull String REL_PATTERN_EDGE_PREFIX = "E.";
    public static final @NonNull String REL_PATTERN_EXPRESSION_PREFIX = "X.";
    public static final @NonNull String TX_DIAGRAM_PREFIX = "T.";
    public static final @NonNull String TX_KEY_PREFIX = "K.";
    public static final @NonNull String TX_KEY_PART_PREFIX = "Kp.";
    public static final @NonNull String TX_MODEL_PARAMETER_PREFIX = "Tp.";
    public static final @NonNull String TX_QUERY_PREFIX = "Q.";
    public static final @NonNull String TX_QUERY_PARAMETER_PREFIX = "Qp.";
    public static final @NonNull String TX_USED_PACKAGE_PREFIX = "U.";
    protected final @NonNull StringBuilder s = new StringBuilder();

    public UMLX2XMIidVisitor(@NonNull UMLX2XMIid context) {
        super(context);
    }

    protected static void appendEPackage(@NonNull StringBuilder s, @NonNull EPackage ePackage) {
        EPackage eSuperPackage = ePackage.getESuperPackage();
        if (eSuperPackage != null) {
            UMLX2XMIidVisitor.appendEPackage(s, eSuperPackage);
            s.append(SCOPE_SEPARATOR);
        }
        UMLX2XMIidVisitor.appendName(s, ePackage.getName());
    }

    protected static void appendName(@NonNull StringBuilder s, @Nullable String name) {
        if (name == null) {
            s.append(NULL_MARKER);
        } else {
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if ('0' <= c && c <= '9') {
                    s.append(c);
                } else if ('A' <= c && c <= 'Z') {
                    s.append(c);
                } else if ('a' <= c && c <= 'z') {
                    s.append(c);
                } else if (c == '_') {
                    s.append(c);
                } else if (c == '$') {
                    s.append(c);
                } else if (c == '%') {
                    s.append("%%");
                } else {
                    s.append("%");
                    s.append((int)c);
                    s.append("%");
                }
                ++i;
            }
        }
    }

    protected static void appendNameOf(@NonNull StringBuilder s, @NonNull Object element) {
        if (element instanceof UMLXNamedElement) {
            s.append(((UMLXNamedElement)element).getName());
        } else if (element instanceof TxKeyNode) {
            EClass eClass = ((TxKeyNode)element).getReferredEClass();
            if (eClass != null) {
                EPackage ePackage = eClass.getEPackage();
                if (ePackage != null) {
                    UMLX2XMIidVisitor.appendEPackage(s, ePackage);
                    s.append(SCOPE_SEPARATOR);
                }
                UMLX2XMIidVisitor.appendName(s, eClass.getName());
            }
        } else if (element instanceof RelDomainNode) {
            String name;
            TxTypedModelNode txTypedModelNode = ((RelDomainNode)element).getReferredTxTypedModelNode();
            String string = name = txTypedModelNode != null ? txTypedModelNode.getName() : "";
            if (name != null) {
                UMLX2XMIidVisitor.appendName(s, name);
            }
        } else if (element instanceof RelInvocationNode) {
            RelInvocationNode relInvocationNode = (RelInvocationNode)element;
            RelDiagram owningRelDiagram = UMLXUtil.getOwningRelDiagram(relInvocationNode);
            RelDiagram referredRelDiagram = relInvocationNode.getReferredRelDiagram();
            int duplicates = 0;
            for (RelInvocationNode anInvocationNode : UMLXUtil.getOwnedRelInvocationNodes(owningRelDiagram)) {
                if (anInvocationNode.getReferredRelDiagram() != referredRelDiagram) continue;
                ++duplicates;
            }
            UMLX2XMIidVisitor.appendName(s, referredRelDiagram.getName());
            if (duplicates > 1) {
                s.append("~");
                StringBuilder s2 = new StringBuilder();
                boolean needHash = false;
                List<@NonNull RelInvocationEdge> sortedInvocationEdges = UMLXUtil.getSortedInvocationEdges(relInvocationNode);
                for (RelInvocationEdge relInvocationEdge : sortedInvocationEdges) {
                    RelPatternNode invokingRelPatternNode;
                    if (s2.length() > 0) {
                        s2.append(SCOPE_SEPARATOR);
                    }
                    if ((invokingRelPatternNode = UMLXUtil.getInvokingRelPatternNode(relInvocationEdge)).isExpression().booleanValue()) {
                        needHash = true;
                    }
                    UMLX2XMIidVisitor.appendNameOf(s2, invokingRelPatternNode);
                }
                String argsString = s2.toString();
                if (needHash) {
                    s.append(Integer.toString(argsString.hashCode()));
                } else {
                    s.append(argsString);
                    s.append("~");
                }
            }
        } else if (element instanceof RelPatternNode && ((RelPatternNode)element).isExpression().booleanValue()) {
            RelPatternNode relPatternExpressionNode = (RelPatternNode)element;
            List<@NonNull RelPatternEdge> incoming = UMLXUtil.Internal.getIncomingList(relPatternExpressionNode);
            if (incoming.size() == 1) {
                UMLX2XMIidVisitor.appendNameOf(s, UMLXUtil.getSource(incoming.get(0)));
            } else {
                EList<String> initExpressionLines = relPatternExpressionNode.getInitExpressionLines();
                int hash = initExpressionLines.hashCode();
                s.append(Integer.toString(hash));
            }
        } else {
            s.append(System.identityHashCode(element));
        }
    }

    protected void appendParent(@Nullable EObject element) {
        this.appendParent(element, SCOPE_SEPARATOR);
    }

    protected void appendParent(@Nullable EObject element, @Nullable String suffixSeparator) {
        if (this.toString().length() >= 1024) {
            this.s.append(OVERFLOW_MARKER);
        } else if (element == null) {
            this.s.append(NULL_MARKER);
            if (suffixSeparator != null) {
                this.s.append(suffixSeparator);
            }
        } else {
            EObject eContainer = element.eContainer();
            if (!(eContainer instanceof UMLXModel) && eContainer != null) {
                this.appendParent(eContainer);
                UMLX2XMIidVisitor.appendNameOf(this.s, eContainer);
                if (suffixSeparator != null) {
                    this.s.append(suffixSeparator);
                }
            }
        }
    }

    public @Nullable String getID(@NonNull UMLXElement element, boolean internalUUIDs) {
        Boolean status = element.accept(this);
        if (status == null) {
            return null;
        }
        if (status.booleanValue()) {
            return this.s.toString();
        }
        return null;
    }

    public String toString() {
        return this.s.toString();
    }

    @Override
    public @Nullable Boolean visiting(@NonNull UMLXElement visitable) {
        System.out.println("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
        return null;
    }

    @Override
    public Boolean visitRelDiagram(@NonNull RelDiagram object) {
        this.s.append(REL_DIAGRAM_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitRelDomainNode(@NonNull RelDomainNode object) {
        this.s.append(REL_DOMAIN_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitRelInvocationEdge(@NonNull RelInvocationEdge object) {
        this.s.append(REL_INVOCATION_EDGE_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendName(this.s, object.getReferredRelPatternNode().getName());
        return true;
    }

    @Override
    public Boolean visitRelInvocationNode(@NonNull RelInvocationNode object) {
        this.s.append(REL_INVOCATION_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitRelPatternEdge(@NonNull RelPatternEdge object) {
        this.s.append(REL_PATTERN_EDGE_PREFIX);
        this.appendParent(object, FIELD_SEPARATOR);
        RelPatternNode source = object.getSource();
        if (source != null) {
            UMLX2XMIidVisitor.appendNameOf(this.s, source);
        }
        this.s.append(FIELD_SEPARATOR);
        RelPatternNode target = object.getTarget();
        if (target != null) {
            UMLX2XMIidVisitor.appendNameOf(this.s, target);
        }
        return true;
    }

    @Override
    public @Nullable Boolean visitRelPatternNode(@NonNull RelPatternNode object) {
        if (object.isExpression().booleanValue()) {
            this.s.append(REL_PATTERN_EXPRESSION_PREFIX);
            this.appendParent(object);
            UMLX2XMIidVisitor.appendNameOf(this.s, object);
            return true;
        }
        this.s.append(REL_PATTERN_CLASS_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitTxDiagram(@NonNull TxDiagram object) {
        this.s.append(TX_DIAGRAM_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitTxKeyNode(@NonNull TxKeyNode object) {
        this.s.append(TX_KEY_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitTxPackageNode(@NonNull TxPackageNode object) {
        String name = object.getReferredEPackage().getName();
        if (name != null) {
            this.s.append(TX_USED_PACKAGE_PREFIX);
            this.appendParent(object);
            UMLX2XMIidVisitor.appendName(this.s, name);
            return true;
        }
        return true;
    }

    @Override
    public Boolean visitTxParameterNode(@NonNull TxParameterNode object) {
        this.s.append(TX_QUERY_PARAMETER_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        return true;
    }

    @Override
    public Boolean visitTxPartNode(@NonNull TxPartNode object) {
        String name = object.getReferredEStructuralFeature().getName();
        if (name != null) {
            this.s.append(TX_KEY_PART_PREFIX);
            this.appendParent(object);
            if (object.isIsOpposite()) {
                this.s.append("~");
            }
            UMLX2XMIidVisitor.appendName(this.s, name);
            return true;
        }
        return true;
    }

    @Override
    public Boolean visitTxQueryNode(@NonNull TxQueryNode object) {
        this.s.append(TX_QUERY_PREFIX);
        this.appendParent(object);
        UMLX2XMIidVisitor.appendNameOf(this.s, object);
        for (TxParameterNode txParameterNode : object.getOwnedTxParameterNodes()) {
            this.s.append(FIELD_SEPARATOR);
            if (txParameterNode == null) continue;
            UMLX2XMIidVisitor.appendNameOf(this.s, txParameterNode);
        }
        return true;
    }

    @Override
    public Boolean visitTxTypedModelNode(@NonNull TxTypedModelNode object) {
        String name = object.getName();
        if (name != null) {
            this.s.append(TX_MODEL_PARAMETER_PREFIX);
            this.appendParent(object);
            UMLX2XMIidVisitor.appendName(this.s, name);
            return true;
        }
        return true;
    }

    @Override
    public Boolean visitUMLXModel(@NonNull UMLXModel object) {
        return null;
    }
}

