/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.core;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBRMPreferenceConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.core.LaunchController;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBExtensionUtils;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;

public class LaunchControllerManager {
    private static final LaunchControllerManager fInstance = new LaunchControllerManager();
    private static final Map<String, ILaunchController> fControllers = Collections.synchronizedMap(new HashMap());

    public static String generateControlId(String remoteServicesId, String connectionName, String configName) {
        String controlBytes = String.valueOf(remoteServicesId) + "/" + connectionName + "/" + configName;
        return UUID.nameUUIDFromBytes(controlBytes.getBytes()).toString();
    }

    public static LaunchControllerManager getInstance() {
        return fInstance;
    }

    private LaunchControllerManager() {
    }

    public ILaunchController getLaunchController(String controlId) {
        return fControllers.get(controlId);
    }

    public ILaunchController getLaunchController(String remoteServicesId, String connectionName, String configName) throws CoreException {
        if (remoteServicesId != null && connectionName != null && configName != null) {
            URL url;
            String controlId = LaunchControllerManager.generateControlId(remoteServicesId, connectionName, configName);
            ILaunchController controller = fControllers.get(controlId);
            if (controller == null && (url = JAXBExtensionUtils.getConfigurationURL((String)configName)) != null) {
                controller = new LaunchController();
                controller.setRMConfigurationURL(url);
                if (connectionName != null && remoteServicesId != null) {
                    controller.setConnectionName(connectionName);
                    controller.setRemoteServicesId(remoteServicesId);
                }
                controller.initialize();
                fControllers.put(controlId, controller);
            }
            boolean reload = Preferences.getBoolean((String)JAXBControlCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.FORCE_XML_RELOAD);
            if (controller != null && (!controller.isInitialized() || reload)) {
                controller.initialize();
            }
            return controller;
        }
        return null;
    }
}

