/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.DataTLB;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.InstructionTLB;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.UnifiedTLB;
import org.xml.sax.Attributes;

public class TLB {
    private String type;
    private int level;
    private int entries;
    private int associativity;
    private String associativityType;
    private static final String TLBTAG = "tlb";
    private static final String TYPEATT = "type";
    private static final String LEVELATT = "level";
    private static final String ENTRIESTAG = "entries";
    private static final String ASSOCTAG = "associativity";
    private static final String ITLB = "instruction";
    private static final String DTLB = "data";
    private static final String UTLB = "unified";
    private String tmpValue = "";
    private static final Set<String> keySet = new TreeSet<String>();

    static {
        keySet.add(TLBTAG);
        keySet.add(ENTRIESTAG);
        keySet.add(ASSOCTAG);
    }

    static boolean containsKey(String str) {
        return keySet.contains(str);
    }

    static TLB newInstance(String type) {
        if (type == null) {
            return new TLB();
        }
        if (type.equalsIgnoreCase(ITLB)) {
            return new InstructionTLB();
        }
        if (type.equalsIgnoreCase(DTLB)) {
            return new DataTLB();
        }
        if (type.equalsIgnoreCase(UTLB)) {
            return new UnifiedTLB();
        }
        return new TLB();
    }

    TLB() {
    }

    void startElement(String uri, String localName, String qName, Attributes atts) {
        if (qName.equals(TLBTAG)) {
            this.type = atts.getValue(TYPEATT);
            this.level = Integer.parseInt(atts.getValue(LEVELATT));
            if (this.level <= 0) {
                String str = "Wrong TLB level value '" + atts.getValue(LEVELATT) + "' . Should be > 0.";
                throw new RuntimeException(str);
            }
        } else if (qName.equals(ASSOCTAG)) {
            this.associativityType = atts.getValue(TYPEATT);
        }
        this.tmpValue = "";
    }

    void characters(char[] ch, int start, int length) {
        String tmpString = new String(ch, start, length);
        if (tmpString.length() != 0) {
            this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
        }
    }

    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (qName.equals(ENTRIESTAG)) {
            this.entries = Integer.parseInt(this.tmpValue);
            if (this.entries <= 0) {
                String str = "Wrong TLB entries value '" + this.tmpValue + "' . Should be > 0.";
                throw new RuntimeException(str);
            }
        } else if (qName.equals(ASSOCTAG) && !this.tmpValue.equals("")) {
            this.associativity = Integer.parseInt(this.tmpValue);
            if (this.associativity < 0) {
                String str = "Wrong TLB associativity value '" + this.tmpValue + "' . Should be >= 0.";
                throw new RuntimeException(str);
            }
        }
        this.tmpValue = "";
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("entries: " + this.entries);
        res.append(", associativity: " + this.associativity);
        res.append(", associativity type: \"" + this.associativityType + "\"");
        return res.toString();
    }

    public String getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEntries() {
        return this.entries;
    }

    public int getAssociativity() {
        return this.associativity;
    }

    public String getAssociativityType() {
        return this.associativityType;
    }
}

