/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.PS_Debug;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.ExecutionInfo;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.MachineInfo;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcReport;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Module;
import org.xml.sax.Attributes;

public class PS_HwpcPCProfileReport
extends PS_HwpcReport {
    private static final String PDATATAG = "hwpcprofiledata";
    private static final String CLASSATT = "class";
    private static final String CLASSVERSIONATT = "version";
    private static final String PINFOTAG = "profileinfo";
    private static final String PEVENTTAG = "profileevent";
    private static final String DOMAINATT = "domain";
    private static final String TYPEATT = "type";
    private static final String NAMEATT = "name";
    private static final String DERIVEDATT = "derived";
    private static final String THRESHOLDTAG = "threshold";
    private static final String TOTALSAMPLESTAG = "totalsamples";
    private static final String MODULETAG = "module";
    private static final String FILEATT = "file";
    private static final String OFFSETATT = "offset";
    private static final String SAMPLESTAG = "samples";
    private static final String SAMPLETAG = "sample";
    private static final String PCATT = "pc";
    private ExecutionInfo executionInfo = new ExecutionInfo();
    private MachineInfo machineInfo = new MachineInfo();
    private String className;
    private String classVersion;
    private String eventDomain;
    private String eventType;
    private String eventName;
    private boolean eventDerived;
    private long threshold;
    private long totalSamples;
    private List<PS_Module> moduleList = new ArrayList<PS_Module>();
    private String tmpValue = "";
    private String tmpElementName;
    private PS_Module tmpModule;
    private String tmpPc;

    PS_HwpcPCProfileReport() {
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes atts) {
        this.tmpElementName = qName;
        if (ExecutionInfo.containsKey(qName)) {
            this.executionInfo.startElement(uri, localName, qName, atts);
        } else if (MachineInfo.containsKey(qName)) {
            this.machineInfo.startElement(uri, localName, qName, atts);
        } else {
            String tagname = qName.trim();
            if (tagname.equals(PDATATAG)) {
                this.className = atts.getValue(CLASSATT);
                this.classVersion = atts.getValue(CLASSVERSIONATT);
            } else if (tagname.equals(PEVENTTAG)) {
                this.eventDomain = atts.getValue(DOMAINATT);
                this.eventType = atts.getValue(TYPEATT);
                this.eventName = atts.getValue(NAMEATT);
                this.eventDerived = atts.getValue(DERIVEDATT).equals("yes");
            } else if (tagname.equals(MODULETAG)) {
                this.tmpModule = new PS_Module(atts.getValue(FILEATT), atts.getValue(OFFSETATT));
            } else if (tagname.equals(SAMPLETAG)) {
                this.tmpPc = atts.getValue(PCATT);
            }
            this.tmpValue = "";
        }
    }

    @Override
    void characters(char[] ch, int start, int length) {
        if (this.tmpElementName == null) {
            return;
        }
        if (ExecutionInfo.containsKey(this.tmpElementName)) {
            this.executionInfo.characters(ch, start, length);
        } else if (MachineInfo.containsKey(this.tmpElementName)) {
            this.machineInfo.characters(ch, start, length);
        } else {
            String tmpString = new String(ch, start, length);
            if (tmpString.length() != 0) {
                this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
            }
        }
    }

    @Override
    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (ExecutionInfo.containsKey(qName)) {
            this.executionInfo.endElement(uri, localName, qName);
        } else if (MachineInfo.containsKey(qName)) {
            this.machineInfo.endElement(uri, localName, qName);
        } else if (qName.equals(SAMPLETAG)) {
            Long pc = -1L;
            Long count = -1L;
            try {
                pc = Long.parseLong(this.tmpPc, 16);
                count = Long.parseLong(this.tmpValue);
                if (count <= 0L) {
                    PS_Debug.print(2, "count (" + String.valueOf(count) + ") <= 0 for pc " + this.tmpPc);
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
            if (pc >= 0L && count > 0L) {
                this.tmpModule.addSample(pc, count);
            }
        } else if (qName.equals(MODULETAG)) {
            this.moduleList.add(this.tmpModule);
        } else if (qName.equals(THRESHOLDTAG)) {
            this.threshold = Long.parseLong(this.tmpValue);
        } else if (qName.equals(TOTALSAMPLESTAG)) {
            this.totalSamples = Long.parseLong(this.tmpValue);
        }
        this.tmpValue = "";
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(super.toString());
        res.append(this.executionInfo.toString());
        res.append(this.machineInfo.toString());
        res.append("Profile Information\n");
        res.append("  [Class:         " + this.className + "]\n");
        if (this.classVersion != null) {
            res.append("  [Version:       " + this.classVersion + "]\n");
        }
        res.append("  [Event Domain:  " + this.eventDomain + "]\n");
        res.append("  [Event Name:    " + this.eventName + "]\n");
        res.append("  [Event Type:    " + this.eventType + "]\n");
        res.append("  [Event Derived: " + this.eventDerived + "]\n");
        res.append("Module Counts (" + this.moduleList.size() + " modules)\n");
        for (PS_Module module : this.moduleList) {
            res.append(module.toString());
        }
        return res.toString();
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassVersion() {
        return this.classVersion;
    }

    public String getEventDomain() {
        return this.eventDomain;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public boolean getEventDerived() {
        return this.eventDerived;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public List<PS_Module> getModules() {
        return this.moduleList;
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    public MachineInfo getMachineInfo() {
        return this.machineInfo;
    }

    public float getWallSecs() {
        float mhz = this.getMachineInfo().getCPUInfo().getClockSpeed();
        long wallTicks = this.getExecutionInfo().getWallTicks();
        float wallsecs = 0L == wallTicks ? this.getExecutionInfo().getWallSecs() : (float)wallTicks / (mhz * 1000000.0f);
        return wallsecs;
    }
}

