/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.Cache;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.ExecutionInfo;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.InstructionTraceCache;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.MachineInfo;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcEvent;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcReport;
import org.xml.sax.Attributes;

public class PS_HwpcCountingReport
extends PS_HwpcReport {
    private static final String EDATATAG = "hwpceventdata";
    private static final String EVENTTAG = "hwpcevent";
    private static final String NAMEATT = "name";
    private static final String TYPEATT = "type";
    private static final String DERIVEDATT = "derived";
    private static final String CLASSATT = "class";
    private static final String CLASSVERSIONATT = "version";
    private static final String DOMAINATT = "domain";
    private static final String MPXATT = "multiplexed";
    private static final String MPXUSATT = "multiplex_usec";
    private static final long DEFAULT_MPX_USEC = 10000L;
    private ExecutionInfo executionInfo = new ExecutionInfo();
    private MachineInfo machineInfo = new MachineInfo();
    private String className;
    private String classVersion;
    private String domain;
    private boolean multiplexed;
    private long multiplex_usec = 10000L;
    private Map<String, PS_HwpcEvent> eventMap;
    private String tmpValue = "";
    private String tmpElementName;
    private PS_HwpcEvent tmpHwpcEvent;

    PS_HwpcCountingReport() {
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes atts) {
        this.tmpElementName = qName;
        if (ExecutionInfo.containsKey(qName)) {
            this.executionInfo.startElement(uri, localName, qName, atts);
        } else if (MachineInfo.containsKey(qName)) {
            this.machineInfo.startElement(uri, localName, qName, atts);
        } else {
            String tagname = qName.trim();
            if (tagname.equals(EDATATAG)) {
                this.className = atts.getValue(CLASSATT);
                this.classVersion = atts.getValue(CLASSVERSIONATT);
                this.domain = atts.getValue(DOMAINATT);
                this.multiplexed = atts.getValue(MPXATT).equals("yes");
                if (atts.getValue(MPXUSATT) != null) {
                    this.multiplex_usec = Long.parseLong(atts.getValue(MPXUSATT));
                }
            } else if (tagname.equals(EVENTTAG)) {
                if (this.eventMap == null) {
                    this.eventMap = new TreeMap<String, PS_HwpcEvent>();
                }
                this.tmpHwpcEvent = new PS_HwpcEvent(atts.getValue(NAMEATT), atts.getValue(TYPEATT), atts.getValue(DERIVEDATT));
            }
            this.tmpValue = "";
        }
    }

    @Override
    void characters(char[] ch, int start, int length) {
        if (this.tmpElementName == null) {
            return;
        }
        if (ExecutionInfo.containsKey(this.tmpElementName)) {
            this.executionInfo.characters(ch, start, length);
        } else if (MachineInfo.containsKey(this.tmpElementName)) {
            this.machineInfo.characters(ch, start, length);
        } else {
            String tmpString = new String(ch, start, length);
            if (tmpString.length() != 0) {
                this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
            }
        }
    }

    @Override
    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (ExecutionInfo.containsKey(qName)) {
            this.executionInfo.endElement(uri, localName, qName);
        } else if (MachineInfo.containsKey(qName)) {
            this.machineInfo.endElement(uri, localName, qName);
        } else if (qName.equals(EVENTTAG)) {
            this.tmpHwpcEvent.setCount(Long.parseLong(this.tmpValue));
            this.eventMap.put(this.tmpHwpcEvent.getName(), this.tmpHwpcEvent);
        }
        this.tmpValue = "";
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(super.toString());
        res.append(this.executionInfo.toString());
        res.append(this.machineInfo.toString());
        res.append("Event Information\n");
        res.append("  [Class:       " + this.className + "]\n");
        if (this.classVersion != null) {
            res.append("  [Version:     " + this.classVersion + "]\n");
        }
        res.append("  [Domain:      " + this.domain + "]\n");
        res.append("  [Multiplexed: " + this.multiplexed + "]\n");
        if (this.multiplex_usec != 0L) {
            res.append("  [Multiplex interval: " + this.multiplex_usec + " (micro-seconds)]\n");
        }
        res.append("Event Counts (" + this.eventMap.size() + " events)\n");
        for (Map.Entry<String, PS_HwpcEvent> entry : this.eventMap.entrySet()) {
            res.append("  [" + entry.getValue() + "]\n");
        }
        return res.toString();
    }

    public Map<String, PS_HwpcEvent> getEvents() {
        return this.eventMap;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassVersion() {
        return this.classVersion;
    }

    public String getEventDomain() {
        return this.domain;
    }

    public boolean getMultiplexed() {
        return this.multiplexed;
    }

    public long getMultiplexUS() {
        return this.multiplex_usec;
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    public MachineInfo getMachineInfo() {
        return this.machineInfo;
    }

    public float getWallSecs() {
        float mhz = this.getMachineInfo().getCPUInfo().getClockSpeed();
        long wallTicks = this.getExecutionInfo().getWallTicks();
        float wallsecs = 0L == wallTicks ? this.getExecutionInfo().getWallSecs() : (float)wallTicks / (mhz * 1000000.0f);
        return wallsecs;
    }

    public Map<String, Double> getEventValueMap() {
        long wallTicks;
        TreeMap<String, Double> inMap = new TreeMap<String, Double>();
        for (Map.Entry<String, PS_HwpcEvent> entry : this.getEvents().entrySet()) {
            inMap.put(entry.getKey().toUpperCase(), new Double(entry.getValue().getCount()));
        }
        float mhz = this.getMachineInfo().getCPUInfo().getClockSpeed();
        inMap.put("MHZ", new Double(mhz));
        String cycleCounter = null;
        if (this.className.equals("PAPI")) {
            cycleCounter = "PAPI_TOT_CYC";
        } else if (this.className.equals("perfmon")) {
            cycleCounter = "CPU_CYCLES";
        } else {
            String details = "Class name: " + this.className + ". Metric calculations are currently supported only " + "for class \"PAPI\" and \"perfmon\". " + "cycleCounter event, which is used to calculate CPU time, " + "is not defined for other classes of events.";
            throw new UnsupportedOperationException(details);
        }
        Double cycleCounterValue = (Double)inMap.get(cycleCounter);
        if (cycleCounterValue != null) {
            Double cpusecs = new Double(cycleCounterValue / ((double)mhz * 1000000.0));
            inMap.put("CPUSECS", cpusecs);
        }
        double wallsecs = 0L == (wallTicks = this.getExecutionInfo().getWallTicks()) ? (double)this.getExecutionInfo().getWallSecs() : (double)((float)wallTicks / (mhz * 1000000.0f));
        inMap.put("WALLSECS", wallsecs);
        int cacheLevels = this.getMachineInfo().getCPUInfo().getCacheLevels();
        List<List<Cache>> caches = this.getMachineInfo().getCPUInfo().getCaches();
        if (caches.size() >= cacheLevels) {
            int i = 0;
            while (i < cacheLevels) {
                String key = "l" + i + "cacheline";
                List<Cache> cacheList = caches.get(i);
                if (cacheList != null) {
                    for (Cache cache : cacheList) {
                        if (cache instanceof InstructionTraceCache) continue;
                        inMap.put(("l" + cache.getLevel() + "cacheline").toUpperCase(), new Double(cache.getLineSize()));
                        break;
                    }
                }
                ++i;
            }
        }
        return inMap;
    }
}

