/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ptp.debug.core.model.IRestart;
import org.eclipse.ptp.internal.debug.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;

public class RestartActionDelegate
extends AbstractListenerActionDelegate {
    protected void doAction(Object element) throws DebugException {
        IRestart restartTarget = this.getRestartTarget(element);
        if (restartTarget != null) {
            restartTarget.restart();
        }
    }

    protected boolean isEnabledFor(Object element) {
        IRestart restartTarget = this.getRestartTarget(element);
        if (restartTarget != null) {
            return this.checkCapability(restartTarget);
        }
        return false;
    }

    protected boolean checkCapability(IRestart element) {
        return element.canRestart();
    }

    protected String getStatusMessage() {
        return Messages.RestartActionDelegate_0;
    }

    protected String getErrorDialogMessage() {
        return Messages.RestartActionDelegate_1;
    }

    protected String getErrorDialogTitle() {
        return Messages.RestartActionDelegate_2;
    }

    protected boolean isRunInBackground() {
        return true;
    }

    protected IRestart getRestartTarget(Object element) {
        if (element instanceof IAdaptable) {
            return (IRestart)((IAdaptable)element).getAdapter(IRestart.class);
        }
        return this.getDefaultRestartTarget(element);
    }

    private IRestart getDefaultRestartTarget(Object element) {
        IDebugTarget target;
        if (element instanceof IDebugElement && (target = ((IDebugElement)element).getDebugTarget()) instanceof IRestart) {
            return (IRestart)target;
        }
        return null;
    }
}

