/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.sourcelookup;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;

public class ResourceMappingSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(PTPDebugCorePlugin.getUniqueIdentifier()) + ".containerType.resourceMapping";
    private IPath fPath;
    private IContainer fContainer;

    public ResourceMappingSourceContainer() {
        this.fPath = Path.EMPTY;
        this.fContainer = null;
    }

    public ResourceMappingSourceContainer(IPath path, IContainer container) {
        this.fPath = path;
        this.fContainer = container;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceMappingSourceContainer)) {
            return false;
        }
        ResourceMappingSourceContainer entry = (ResourceMappingSourceContainer)((Object)o);
        return entry.getPath().equals((Object)this.getPath()) && entry.getContainer().equals((Object)this.getContainer());
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IFile file;
        Path path = new Path(name);
        if (path.isAbsolute()) {
            if (!this.getPath().isPrefixOf((IPath)path)) {
                return EMPTY;
            }
            path = path.removeFirstSegments(this.getPath().segmentCount());
        }
        if ((file = this.getContainer().getFile((IPath)path)).exists()) {
            return new Object[]{file};
        }
        return EMPTY;
    }

    public IPath getCompilationPath(String path) {
        Path sourcePath = new Path(path);
        if (!sourcePath.isAbsolute()) {
            return this.getPath().append((IPath)sourcePath);
        }
        IContainer container = this.getContainer();
        IPath localPath = container.getProject().getLocation();
        if (localPath != null) {
            localPath.append(container.getProjectRelativePath());
            if (localPath.isPrefixOf((IPath)sourcePath)) {
                return this.getPath().append(sourcePath.removeFirstSegments(localPath.segmentCount()));
            }
        }
        return null;
    }

    public IContainer getContainer() {
        return this.fContainer;
    }

    public String getName() {
        return NLS.bind((String)"{0}/{1} <-> {2}", (Object[])new Object[]{this.getContainer().getProject().getName(), this.getContainer().getProjectRelativePath(), this.getPath().toOSString()});
    }

    public IPath getPath() {
        return this.fPath;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public void setContainer(IContainer container) {
        this.fContainer = container;
    }

    public void setPath(IPath path) {
        this.fPath = path;
    }
}

