/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.request;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDataReadMemoryInfo;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDataReadMemoryRequest;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.request.AbstractEventResultRequest;

public abstract class AbstractDataReadMemoryRequest
extends AbstractEventResultRequest
implements IPDIDataReadMemoryRequest {
    private final long offset;
    private final String address;
    private final int wordFormat;
    private final int wordSize;
    private final int rows;
    private final int cols;
    private final Character asChar;

    public AbstractDataReadMemoryRequest(TaskSet tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) {
        super(tasks);
        this.offset = offset;
        this.address = address;
        this.wordFormat = wordFormat;
        this.wordSize = wordSize;
        this.rows = rows;
        this.cols = cols;
        this.asChar = asChar;
    }

    @Override
    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.createDataReadMemory(this.tasks, this.offset, this.address, this.wordFormat, this.wordSize, this.rows, this.cols, this.asChar);
    }

    @Override
    public IPDIDataReadMemoryInfo getDataReadMemoryInfo(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof IPDIDataReadMemoryInfo) {
            return (IPDIDataReadMemoryInfo)obj;
        }
        throw new PDIException(qTasks, Messages.AbstractDataReadMemoryRequest_0);
    }

    @Override
    public String getName() {
        return Messages.AbstractDataReadMemoryRequest_1;
    }
}

