/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAggregate;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeInt;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeUnion;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueChar;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueFloat;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueInt;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValuePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueString;
import org.eclipse.ptp.debug.core.pdi.model.aif.ITypeDerived;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.model.AbstractPValue;
import org.eclipse.ptp.internal.debug.core.model.AbstractPVariable;
import org.eclipse.ptp.internal.debug.core.model.PVariable;
import org.eclipse.ptp.internal.debug.core.model.PVariableFactory;

public class PValue
extends AbstractPValue {
    private String fValueString = null;
    private IPDIVariable fVariable;
    private List<IVariable> fVariables = Collections.emptyList();

    protected PValue(PVariable parent, IPDIVariable variable) {
        super(parent);
        this.fVariable = variable;
    }

    protected PValue(PVariable parent, String message) {
        super(parent);
        this.setStatus(2, message);
    }

    @Override
    public void dispose() {
        Iterator<IVariable> it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).dispose();
        }
    }

    @Override
    public IAIF getAIF() throws DebugException {
        try {
            return this.fVariable.getAIF();
        }
        catch (PDIException e) {
            PValue.targetRequestFailed(e.getMessage(), e);
            return null;
        }
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getAIF() != null) {
            boolean isSuspended;
            this.resetStatus();
            IPStackFrame pframe = this.getParentVariable().getStackFrame();
            boolean bl = isSuspended = pframe == null ? this.getPDISession().isSuspended(this.getTasks()) : pframe.isSuspended();
            if (isSuspended) {
                try {
                    if (this.fVariable == null) {
                        PValue.targetRequestFailed(Messages.PValue_0, null);
                    }
                    this.fValueString = this.processUnderlyingValue(this.getAIF());
                }
                catch (AIFException pe) {
                    this.setStatus(2, pe.getMessage());
                }
            }
        }
        return this.fValueString;
    }

    public IVariable[] getVariables() throws DebugException {
        List<IVariable> list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    public boolean hasVariables() throws DebugException {
        IAIFType type;
        IAIF aif = this.getAIF();
        return aif != null && ((type = aif.getType()) instanceof IAIFTypeAggregate || type instanceof IAIFTypeUnion || type instanceof ITypeDerived);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    private String getCharValueString(IAIFValueChar value) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        char charValue = value.charValue();
        if (PVariableFormat.NATURAL.equals(format)) {
            return value.getValueString();
        }
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Integer.toString((byte)charValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Integer.toString((byte)charValue);
            sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getDoubleValueString(String doubleValue) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format)) {
            return doubleValue;
        }
        Double dbl = new Double(doubleValue);
        if (dbl.isNaN() || dbl.isInfinite()) {
            return "";
        }
        long longValue = dbl.longValue();
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
            return sb.toString();
        }
        return doubleValue;
    }

    private String getFloatingPointValueString(IAIFValueFloat value) throws AIFException {
        if (value.isDouble()) {
            return this.getDoubleValueString(value.getValueString());
        }
        if (value.isFloat()) {
            return this.getFloatValueString(value.getValueString());
        }
        return value.getValueString();
    }

    private String getFloatValueString(String floatValue) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format)) {
            return floatValue;
        }
        Float flt = new Float(floatValue);
        if (flt.isNaN() || flt.isInfinite()) {
            return "";
        }
        long longValue = flt.longValue();
        if (PVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(longValue);
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(longValue);
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return floatValue;
    }

    private String getIntValueString(IAIFValueInt value) throws AIFException {
        PVariableFormat format = this.getParentVariable().getFormat();
        String stringValue = value.getValueString();
        if (PVariableFormat.NATURAL.equals(format) || PVariableFormat.DECIMAL.equals(format)) {
            return stringValue;
        }
        if (PVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            if (value.isShort()) {
                stringValue = Integer.toHexString(value.shortValue());
            } else if (value.isInt()) {
                stringValue = Integer.toHexString(value.intValue());
            } else if (value.isLong()) {
                stringValue = Long.toHexString(value.longValue());
            }
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getPointerValueString(IAIFValuePointer value) throws AIFException {
        BigInteger pv = value.pointerValue();
        if (pv == null) {
            return "";
        }
        PVariableFormat format = this.getParentVariable().getFormat();
        if (PVariableFormat.NATURAL.equals(format) || PVariableFormat.HEXADECIMAL.equals(format)) {
            return pv.toString(16);
        }
        if (PVariableFormat.DECIMAL.equals(format)) {
            return pv.toString(10);
        }
        return null;
    }

    private String getWCharValueString(IAIFValueString value) throws AIFException {
        return value.getValueString();
    }

    private String processUnderlyingValue(IAIFType type, IAIFValue value) throws AIFException {
        if (type instanceof IAIFTypeChar) {
            return this.getCharValueString((IAIFValueChar)value);
        }
        if (type instanceof IAIFTypeInt) {
            return this.getIntValueString((IAIFValueInt)value);
        }
        if (type instanceof IAIFTypeFloat) {
            return this.getFloatingPointValueString((IAIFValueFloat)value);
        }
        if (type instanceof IAIFTypePointer) {
            return this.getPointerValueString((IAIFValuePointer)value);
        }
        if (type instanceof IAIFTypeReference) {
            return this.processUnderlyingValue(type, ((IAIFValueReference)value).getParent());
        }
        if (type instanceof IAIFTypeString) {
            return this.getWCharValueString((IAIFValueString)value);
        }
        if (type instanceof IAIFTypeAggregate || type instanceof IAIFTypeUnion) {
            return "{...}";
        }
        return value.getValueString();
    }

    protected List<IPDIVariable> getPDIVariables() throws DebugException {
        IPDIVariable[] vars = null;
        try {
            if (this.fVariable != null && (vars = this.fVariable.getChildren()) == null) {
                vars = new IPDIVariable[]{};
            }
        }
        catch (PDIException e) {
            PValue.requestFailed(e.getMessage(), e);
        }
        return Arrays.asList(vars);
    }

    protected synchronized List<IVariable> getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.emptyList();
        }
        if (this.fVariables.size() == 0) {
            try {
                List<IPDIVariable> vars = this.getPDIVariables();
                this.fVariables = new ArrayList<IVariable>(vars.size());
                Iterator<IPDIVariable> it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(PVariableFactory.createLocalVariable(this, it.next()));
                }
                this.resetStatus();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return this.fVariables;
    }

    @Override
    protected void preserve() {
        this.setChanged(false);
        this.resetStatus();
        Iterator<IVariable> it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).preserve();
        }
    }

    protected String processUnderlyingValue(IAIF aif) throws AIFException {
        if (aif != null) {
            return this.processUnderlyingValue(aif.getType(), aif.getValue());
        }
        return null;
    }

    @Override
    protected void reset() {
        this.resetStatus();
        this.fValueString = null;
        Iterator<IVariable> it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).resetValue();
        }
    }

    @Override
    protected synchronized void setChanged(boolean changed) {
        if (changed) {
            this.fValueString = null;
            this.resetStatus();
        }
        Iterator<IVariable> it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((AbstractPVariable)it.next()).setChanged(changed);
        }
    }
}

