/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;

public class WizardFragmentsFactoryRegistry {
    private static final String EXTENSION_POINT_NAME = "wizardAndCompositeFragments";
    private static final String FRAGMENT_TAG = "wizardAndCompositeFragment";
    private static final String ID_ATTRIBUTE = "id";
    private static final String FRAGMENTS_GROUP_ID = "fragmentsGroupID";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PLACE_AFTER_ATTRIBUTE = "placeAfter";
    private Map<String, List<FragmentsFactory>> fragments;
    private static WizardFragmentsFactoryRegistry instance;
    private Map<String, Map<String, ICompositeFragmentFactory>> factories = new HashMap<String, Map<String, ICompositeFragmentFactory>>();

    public static Map<String, ICompositeFragmentFactory> getFragmentsFactories(String fragmentsGroupID) {
        WizardFragmentsFactoryRegistry registry = WizardFragmentsFactoryRegistry.getInstance();
        Map<String, ICompositeFragmentFactory> factories = registry.factories.get(fragmentsGroupID);
        if (factories == null) {
            factories = new LinkedHashMap<String, ICompositeFragmentFactory>();
            List<FragmentsFactory> fragments = registry.fragments.get(fragmentsGroupID);
            int i = 0;
            while (i < fragments.size()) {
                FragmentsFactory factory = fragments.get(i);
                factories.put(factory.getID(), factory.createFragmentFactory());
                ++i;
            }
            registry.factories.put(fragmentsGroupID, factories);
            registry.fragments.remove(fragmentsGroupID);
        }
        return factories;
    }

    private WizardFragmentsFactoryRegistry() {
        this.fragments = new HashMap<String, List<FragmentsFactory>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (FRAGMENT_TAG.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTRIBUTE);
                String groupID = element.getAttribute(FRAGMENTS_GROUP_ID);
                String placeAfter = element.getAttribute(PLACE_AFTER_ATTRIBUTE);
                List<FragmentsFactory> list = this.fragments.get(groupID);
                if (list == null) {
                    list = new ArrayList<FragmentsFactory>();
                    this.fragments.put(groupID, list);
                }
                if (element.getNamespaceIdentifier().equals("org.eclipse.php.ui")) {
                    list.add(0, new FragmentsFactory(element, id, placeAfter));
                } else {
                    list.add(new FragmentsFactory(element, id, placeAfter));
                }
            }
            ++i;
        }
        Iterator<String> keys = this.fragments.keySet().iterator();
        while (keys.hasNext()) {
            this.sortFragmentsByPlace(this.fragments.get(keys.next()));
        }
    }

    private void sortFragmentsByPlace(List<FragmentsFactory> fragments) {
        ArrayList<List<FragmentsFactory>> rootsFragments = new ArrayList<List<FragmentsFactory>>();
        ArrayList<List<FragmentsFactory>> nonRootFragments = new ArrayList<List<FragmentsFactory>>();
        int i = 0;
        while (i < fragments.size()) {
            FragmentsFactory factory = fragments.get(i);
            if (factory.getPlaceAfter() == null || factory.getPlaceAfter().equals("")) {
                this.addAsList(rootsFragments, factory);
            } else {
                this.addAsList(nonRootFragments, factory);
            }
            ++i;
        }
        i = 0;
        while (i < nonRootFragments.size()) {
            List fragmentsGroup = (List)nonRootFragments.get(i);
            boolean moved = this.placeFragment(rootsFragments, fragmentsGroup);
            if (!moved) {
                moved = this.placeFragment(nonRootFragments, fragmentsGroup);
            }
            if (!moved) {
                FragmentsFactory invalidFactory = this.getFactory(nonRootFragments, i);
                this.addAsList(rootsFragments, invalidFactory);
                PHPUiPlugin.log((IStatus)new Status(2, "org.eclipse.php.ui", 0, "Invalid 'placeAfter' id (" + invalidFactory.getPlaceAfter() + ')', null));
            }
            ++i;
        }
        fragments.clear();
        i = 0;
        while (i < rootsFragments.size()) {
            List list = (List)rootsFragments.get(i);
            int j = 0;
            while (j < list.size()) {
                fragments.add((FragmentsFactory)list.get(j));
                ++j;
            }
            ++i;
        }
    }

    private boolean placeFragment(List<List<FragmentsFactory>> targetFactories, List<FragmentsFactory> factoriesGroup) {
        if (factoriesGroup == null || factoriesGroup.size() == 0) {
            return true;
        }
        FragmentsFactory factory = factoriesGroup.get(0);
        String placeAfter = factory.getPlaceAfter();
        int i = 0;
        while (i < targetFactories.size()) {
            List<FragmentsFactory> list = targetFactories.get(i);
            int j = 0;
            while (j < list.size()) {
                FragmentsFactory nextFactory = list.get(j);
                if (nextFactory.getID().equals(placeAfter)) {
                    if (list.size() > j + 1) {
                        list.addAll(j + 1, factoriesGroup);
                    } else {
                        list.addAll(factoriesGroup);
                    }
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private FragmentsFactory getFactory(List<List<FragmentsFactory>> nonRootFragments, int i) {
        List<FragmentsFactory> list = nonRootFragments.get(i);
        return list.get(0);
    }

    private void addAsList(List<List<FragmentsFactory>> target, FragmentsFactory element) {
        ArrayList<FragmentsFactory> list = new ArrayList<FragmentsFactory>();
        list.add(element);
        target.add(list);
    }

    private static WizardFragmentsFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new WizardFragmentsFactoryRegistry();
        }
        return instance;
    }

    private class FragmentsFactory {
        private IConfigurationElement element;
        private ICompositeFragmentFactory factory;
        private String id;
        private String placeAfter;

        public FragmentsFactory(IConfigurationElement element, String id, String placeAfter) {
            this.element = element;
            this.id = id;
            this.placeAfter = placeAfter;
        }

        public ICompositeFragmentFactory createFragmentFactory() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.server.ui.wizardAndCompositeFragments"){

                public void run() throws Exception {
                    FragmentsFactory.this.factory = (ICompositeFragmentFactory)FragmentsFactory.this.element.createExecutableExtension(WizardFragmentsFactoryRegistry.CLASS_ATTRIBUTE);
                }
            });
            return this.factory;
        }

        public String getID() {
            return this.id;
        }

        public String getPlaceAfter() {
            return this.placeAfter;
        }
    }
}

