/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableSorter {
    private TableViewer fTableViewer = null;
    private ViewerComparator fViewerComparator = null;
    private Comparator<Object> fComparator;
    private HashMap<TableColumn, SelectionAdapter> fSelectionAdapters = null;

    public TableSorter() {
        this(null);
    }

    public TableSorter(Comparator<Object> comparator) {
        this.fComparator = comparator;
        this.fSelectionAdapters = new HashMap();
        this.fViewerComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return TableSorter.this.compareElements(e1, e2);
            }
        };
    }

    public TableSorter(TableViewer viewer, Comparator<Object> comparator) {
        this(comparator);
        this.setTableViewer(viewer);
    }

    protected void tableColumnClicked(TableColumn column) {
        Table table = column.getParent();
        if (column.equals(table.getSortColumn())) {
            table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
        } else {
            table.setSortColumn(column);
            table.setSortDirection(128);
        }
        this.fTableViewer.refresh();
    }

    protected int compareElements(Object e1, Object e2) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTableViewer.getLabelProvider();
        Table table = this.fTableViewer.getTable();
        String text1 = "";
        String text2 = "";
        if (labelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider tableLabelProvider = (ITableLabelProvider)labelProvider;
            int index = Arrays.asList(table.getColumns()).indexOf(table.getSortColumn());
            if (index != -1) {
                text1 = tableLabelProvider.getColumnText(e1, index);
                text2 = tableLabelProvider.getColumnText(e2, index);
            }
        } else {
            text1 = labelProvider.getText(e1);
            text2 = labelProvider.getText(e2);
        }
        int result = this.getComparator().compare(text1, text2);
        return table.getSortDirection() == 128 ? result : -result;
    }

    protected void registerTableViewer(TableViewer viewer) {
        if (viewer == null) {
            return;
        }
        viewer.setComparator(this.fViewerComparator);
        this.addColumnSelectionListeners(viewer);
    }

    protected void unregisterTableViewer(TableViewer viewer) {
        if (viewer == null) {
            return;
        }
        if (viewer.getComparator() == this.fViewerComparator) {
            viewer.setComparator(null);
        }
        this.removeColumnSelectionListeners(viewer);
    }

    protected void addColumnSelectionListeners(TableViewer viewer) {
        if (viewer == null) {
            return;
        }
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            this.addColumnSelectionListener(column);
            ++n2;
        }
    }

    protected void removeColumnSelectionListeners(TableViewer viewer) {
        if (viewer == null) {
            return;
        }
        for (Map.Entry<TableColumn, SelectionAdapter> entry : this.fSelectionAdapters.entrySet()) {
            TableColumn tableColumn = entry.getKey();
            SelectionAdapter selectionAdapter = entry.getValue();
            tableColumn.removeSelectionListener((SelectionListener)selectionAdapter);
        }
        this.fSelectionAdapters.clear();
    }

    protected void addColumnSelectionListener(TableColumn column) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableSorter.this.tableColumnClicked((TableColumn)e.widget);
            }
        };
        column.addSelectionListener((SelectionListener)selectionAdapter);
        this.fSelectionAdapters.put(column, selectionAdapter);
    }

    public void setTableViewer(TableViewer viewer) {
        if (this.fTableViewer == viewer) {
            return;
        }
        this.unregisterTableViewer(this.fTableViewer);
        this.registerTableViewer(viewer);
        this.fTableViewer = viewer;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected Comparator<Object> getComparator() {
        if (this.fComparator == null) {
            this.fComparator = Policy.getComparator();
        }
        return this.fComparator;
    }
}

