/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.php.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class CorrectionCommandInstaller {
    private static Map<String, IHandlerActivation> fActivations = new HashMap<String, IHandlerActivation>();

    private CorrectionCommandInstaller() {
    }

    public static void registerCommands() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        CorrectionCommandInstaller.registerDescriptors(PHPCorrectionProcessor.getAssistProcessors(), handlerService);
        CorrectionCommandInstaller.registerDescriptors(PHPCorrectionProcessor.getCorrectionProcessors(), handlerService);
    }

    private static void registerDescriptors(ContributedProcessorDescriptor[] descriptors, IHandlerService handlerService) {
        ContributedProcessorDescriptor[] contributedProcessorDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ContributedProcessorDescriptor descriptor = contributedProcessorDescriptorArray[n2];
            String[] stringArray = descriptor.getSupportedCommands();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String commandId = stringArray[n4];
                if (fActivations.containsKey(commandId)) {
                    PHPUiPlugin.logErrorMessage("Command ID already registered: " + commandId);
                } else {
                    fActivations.put(commandId, handlerService.activateHandler(commandId, (IHandler)new CorrectionCommandHandler()));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void unregisterCommands() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null) {
            handlerService.deactivateHandlers(fActivations.values());
        }
        fActivations.clear();
    }
}

