/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.io.IOException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;

public final class FindOccurrencesEngine {
    private IOccurrencesFinder fFinder;

    public static FindOccurrencesEngine create(IOccurrencesFinder finder) {
        return new FindOccurrencesEngine(finder);
    }

    private FindOccurrencesEngine(IOccurrencesFinder finder) {
        if (finder == null) {
            throw new IllegalArgumentException();
        }
        this.fFinder = finder;
    }

    private String run(Program astRoot, int offset, int length) {
        String message = this.fFinder.initialize(astRoot, offset, length);
        if (message != null) {
            return message;
        }
        this.performNewSearch(this.fFinder, astRoot.getSourceModule());
        return null;
    }

    public String run(ISourceModule input, int offset, int length) throws ModelException, IOException {
        if (input.getSourceRange() == null) {
            return "SearchMessages.FindOccurrencesEngine_noSource_text";
        }
        Program root = SharedASTProvider.getAST(input, SharedASTProvider.WAIT_YES, null);
        if (root == null) {
            return "SearchMessages.FindOccurrencesEngine_cannotParse_text";
        }
        return this.run(root, offset, length);
    }

    private void performNewSearch(IOccurrencesFinder finder, ISourceModule element) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new OccurrencesSearchQuery(finder, element));
    }
}

