/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectUtil;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.ui.internal.handlers.StructuredSelectPreviousXMLHandler;

public class StructureSelectPreviousHandler
extends StructuredSelectPreviousXMLHandler {
    private ISourceModule sourceModule = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.sourceModule = StructureSelectUtil.getSourceModule(event);
        super.execute(event);
        this.sourceModule = null;
        return null;
    }

    protected Region getNewSelectionRegion(IndexedRegion indexedRegion, ITextSelection textSelection) {
        if (this.sourceModule != null && StructureSelectUtil.isPHP(indexedRegion)) {
            Selection selection = Selection.createFromStartLength((int)textSelection.getOffset(), (int)textSelection.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            try {
                ASTNode previousNode;
                Program ast = StructureSelectUtil.getAST(this.sourceModule);
                ast.accept((Visitor)selAnalyzer);
                Region oldSourceRange = new Region(textSelection.getOffset(), textSelection.getLength());
                if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = PreviousNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
                    return StructureSelectUtil.getSelectedNodeSourceRange((ISourceReference)this.sourceModule, previousNode);
                }
                ASTNode first = selAnalyzer.getFirstSelectedNode();
                if (first == null) {
                    return StructureSelectUtil.getLastCoveringNodeRange(oldSourceRange, (ISourceReference)this.sourceModule, selAnalyzer);
                }
                ASTNode parent = first.getParent();
                if (parent == null) {
                    return StructureSelectUtil.getLastCoveringNodeRange(oldSourceRange, (ISourceReference)this.sourceModule, selAnalyzer);
                }
                ASTNode previousNode2 = StructureSelectPreviousHandler.getPreviousNode(parent, selAnalyzer.getSelectedNodes()[0]);
                if (previousNode2 == parent) {
                    return StructureSelectUtil.getSelectedNodeSourceRange((ISourceReference)this.sourceModule, parent);
                }
                int offset = previousNode2.getStart();
                int end = oldSourceRange.getOffset() + oldSourceRange.getLength() - 1;
                return StructureSelectUtil.createSourceRange(offset, end);
            }
            catch (ModelException modelException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getNewSelectionRegion(indexedRegion, textSelection);
    }

    private static ASTNode getPreviousNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectUtil.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[0]) {
            return parent;
        }
        int index = StructureSelectUtil.findIndex(siblingNodes, node);
        if (index < 1) {
            return parent;
        }
        return siblingNodes[index - 1];
    }

    private static class PreviousNodeAnalyzer
    extends ApplyAll {
        private final int fOffset;
        private ASTNode fPreviousNode;

        private PreviousNodeAnalyzer(int offset) {
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            PreviousNodeAnalyzer analyzer = new PreviousNodeAnalyzer(offset);
            lastCoveringNode.accept((Visitor)analyzer);
            return analyzer.fPreviousNode;
        }

        protected boolean apply(ASTNode node) {
            int start = node.getStart();
            int end = start + node.getLength();
            if (end == this.fOffset) {
                this.fPreviousNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

