/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.ast.ASTCache;
import org.eclipse.php.internal.ui.editor.ast.ASTUtils;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ASTProvider {
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    public static final boolean SHARED_BINDING_RECOVERY = true;
    private static final boolean KEEP_ONLY_ONE_AST = true;
    private final List<ASTCache> cachedASTs = new ArrayList<ASTCache>();
    private ActivationListener fActivationListener;
    private IWorkbenchPart fActiveEditor;
    private ISourceModule fActiveJavaElement;

    public static ASTProvider getASTProvider() {
        return PHPUiPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ASTCache getCacheFor(@NonNull ISourceModule javaElement) {
        List<ASTCache> list = this.cachedASTs;
        synchronized (list) {
            ASTCache c = null;
            int i = this.cachedASTs.size() - 1;
            while (i >= 0) {
                ASTCache current = this.cachedASTs.get(i);
                ISourceModule input = current.getInput();
                if (input == javaElement) {
                    c = current;
                } else if (input == null) {
                    this.cachedASTs.remove(i);
                }
                --i;
            }
            if (c == null) {
                if (this.cachedASTs.size() > 0) {
                    this.cachedASTs.clear();
                }
                c = new ASTCache(javaElement);
                this.cachedASTs.add(c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJavaEditorChanged(IWorkbenchPart editor) {
        ISourceModule javaElement = null;
        if (editor instanceof PHPStructuredEditor) {
            javaElement = (ISourceModule)((PHPStructuredEditor)editor).getModelElement();
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            this.fActiveEditor = editor;
            this.fActiveJavaElement = javaElement;
        }
        if (ASTUtils.DEBUG) {
            System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "active editor is: " + this.toString(javaElement));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(ISourceModule cu) {
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            return cu != null && cu == this.fActiveJavaElement;
        }
    }

    public void aboutToBeReconciled(ISourceModule javaElement) {
        if (ASTUtils.DEBUG) {
            System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "about to reconcile: " + this.toString(javaElement));
        }
        if (javaElement != null) {
            this.getCacheFor(javaElement).aboutToBeReconciled(javaElement);
        }
    }

    public void reconciled(Program ast, ISourceModule javaElement, IProgressMonitor progressMonitor) {
        if (ASTUtils.DEBUG) {
            System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "reconciled: " + this.toString(javaElement) + ", AST: " + this.toString(ast));
        }
        if (javaElement != null) {
            this.getCacheFor(javaElement).reconciled(ast, javaElement, progressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void disposeAST() {
        List<ASTCache> list = this.cachedASTs;
        synchronized (list) {
            this.cachedASTs.clear();
        }
    }

    private String toString(ISourceModule javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(Program ast) {
        if (ast == null) {
            return "null";
        }
        return "AST without any type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program getAST(ISourceModule input, SharedASTProvider.WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        boolean isActiveElement;
        if (input == null || waitFlag == null) {
            throw new IllegalArgumentException("input or wait flag are null");
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = input == this.fActiveJavaElement;
        }
        Program ast = this.getCacheFor(input).getAST(input, SharedASTProvider.WAIT_NO, progressMonitor);
        if (ast != null || waitFlag == SharedASTProvider.WAIT_NO || waitFlag == SharedASTProvider.WAIT_ACTIVE_ONLY && !isActiveElement) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                assert (ast == null);
                ast = null;
                if (ASTUtils.DEBUG) {
                    System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "Ignore created AST for: " + input.getElementName() + " - operation has been cancelled");
                }
            }
            return ast;
        }
        ast = this.getCacheFor(input).getAST(input, SharedASTProvider.WAIT_YES, progressMonitor);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            assert (ast == null);
            ast = null;
            if (ASTUtils.DEBUG) {
                System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "Ignore created AST for: " + input.getElementName() + " - operation has been cancelled");
            }
        }
        return ast;
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (ASTUtils.DEBUG) {
                    System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (ASTUtils.DEBUG) {
                    System.out.println(String.valueOf(ASTUtils.getThreadName()) + " - " + "ASTProvider > " + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isJavaEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.eclipse.php.editor".equals(id) || ref.getPart(false) instanceof PHPStructuredEditor;
        }
    }
}

