/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.views.ExecutionFlowTreeElement;
import org.eclipse.swt.graphics.Image;

public class ExecutionFlowLabelProvider
implements ITableLabelProvider {
    DecimalFormat fDecimalFormat = new DecimalFormat("#0.0#", new DecimalFormatSymbols(new Locale("en")));
    private Image fFunctionImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_MISC_PUBLIC);
    private Image fFileImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_CUNIT);

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fFunctionImage;
            }
            case 1: {
                return this.fFileImage;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ExecutionFlowTreeElement executionFlowElement;
        ProfilerFunctionData functionData;
        if (element instanceof ExecutionFlowTreeElement && (functionData = (ProfilerFunctionData)(executionFlowElement = (ExecutionFlowTreeElement)element).getData()) != null) {
            switch (columnIndex) {
                case 0: {
                    return functionData.toString();
                }
                case 1: {
                    return functionData.getFileName();
                }
                case 2: {
                    return NLS.bind((String)PHPProfileUIMessages.getString("ExecutionFlowLabelProvider_0"), (Object)Double.toString(executionFlowElement.getTimePercentage()));
                }
                case 3: {
                    return this.fDecimalFormat.format(executionFlowElement.getDuration());
                }
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

