/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.WizardFragmentsFactoryRegistry;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PHPExeEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.debug.ui.phpExeWizardCompositeFragment";
    private List<CompositeFragment> runtimeComposites;
    private PHPexeItem phpExeItem;
    private PHPexeItem[] existingItems;
    private String tabID;
    private CTabFolder tabs;

    public PHPExeEditDialog(Shell shell, PHPexeItem phpExeItem, PHPexeItem[] existingItems) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.phpExeItem = phpExeItem.makeCopy();
        this.existingItems = existingItems;
        this.runtimeComposites = new ArrayList<CompositeFragment>(3);
    }

    public PHPExeEditDialog(Shell shell, PHPexeItem phpExeItem, PHPexeItem[] existingItems, String tabID) {
        this(shell, phpExeItem, existingItems);
        this.tabID = tabID;
    }

    public void setDescription(String desc) {
        super.setMessage(desc);
    }

    public PHPexeItem[] getExistingItems() {
        return this.existingItems;
    }

    public void setPHPExeItem(PHPexeItem phpExeItem) {
        this.phpExeItem = phpExeItem;
    }

    public PHPexeItem getPHPExeItem() {
        return this.phpExeItem;
    }

    public void setImageDescriptor(ImageDescriptor image) {
        super.setTitleImage(image.createImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.tabs = SWTUtil.createTabFolder((Composite)parent);
        Map factories = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        Collection factoriesList = factories.values();
        for (ICompositeFragmentFactory element : factoriesList) {
            CTabItem tabItem = new CTabItem(this.tabs, 2048);
            CompositeFragment fragment = element.createComposite((Composite)this.tabs, (IControlHandler)this);
            fragment.setData((Object)this.phpExeItem);
            if (fragment instanceof IPHPExeCompositeFragment) {
                ((IPHPExeCompositeFragment)fragment).setExistingItems(this.existingItems);
            }
            tabItem.setText(fragment.getDisplayName());
            tabItem.setControl((Control)fragment);
            tabItem.setData((Object)fragment.getId());
            this.runtimeComposites.add(fragment);
        }
        this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                CompositeFragment fragment = (CompositeFragment)item.getControl();
                PHPExeEditDialog.this.setTitle(fragment.getTitle());
                PHPExeEditDialog.this.setDescription(fragment.getDescription());
                PHPExeEditDialog.this.setImageDescriptor(fragment.getImageDescriptor());
                fragment.setData((Object)PHPExeEditDialog.this.phpExeItem);
            }
        });
        this.getShell().setText(Messages.PHPExeEditDialog_1);
        if (this.tabID != null) {
            this.setSelect(this.tabID);
        }
        return this.tabs;
    }

    protected void cancelPressed() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            composites.next().performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            composites.next().performOk();
        }
        PHPexeItem original = PHPexes.getInstance().findItem(this.phpExeItem.getUniqueId());
        PHPexes.getInstance().updateItem(original, this.phpExeItem);
        PHPexes.getInstance().save();
        super.okPressed();
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
        super.handleShellCloseEvent();
    }

    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
            while (composites.hasNext()) {
                if (composites.next().isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }

    public IControlHandler.Kind getKind() {
        return IControlHandler.Kind.EDITOR;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
    }

    private void setSelect(String id) {
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.tabs.getItemCount()) {
            if (id.equals(this.tabs.getItem(i).getData())) {
                this.tabs.setSelection(i);
                CompositeFragment fragment = (CompositeFragment)this.tabs.getItem(i).getControl();
                this.setTitle(fragment.getTitle());
                this.setImageDescriptor(fragment.getImageDescriptor());
                this.setDescription(fragment.getDescription());
                fragment.validate();
                break;
            }
            ++i;
        }
    }
}

