/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.ui.editor.PHPSourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class CodeCoverageTextViewer
extends PHPSourceViewer
implements IPropertyChangeListener {
    private static final String COVERED_LINES_COLOR_DEF = "org.eclipse.php.debug.ui.themePHPDebug.codeCoverageCoveredLinesBg";
    private static final String UNCOVERED_LINES_COLOR_DEF = "org.eclipse.php.debug.ui.themePHPDebug.codeCoverageUncoveredLinesBg";
    private IThemeManager fThemeManager;
    private Color fCoveredLineBackground;
    private Color fUncoveredLineBackground;
    private Color fUncoveredSignificantBackground;
    private byte[] fCoverageBitmask = new byte[0];
    private byte[] fSignificanceBitmask = new byte[0];

    public CodeCoverageTextViewer(Composite parent, int style) {
        super(parent, style);
        this.setEditable(false);
        this.fThemeManager = PlatformUI.getWorkbench().getThemeManager();
        this.fThemeManager.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fCoveredLineBackground = this.fThemeManager.getCurrentTheme().getColorRegistry().get(COVERED_LINES_COLOR_DEF);
        this.fUncoveredLineBackground = this.fThemeManager.getCurrentTheme().getColorRegistry().get(UNCOVERED_LINES_COLOR_DEF);
        this.fUncoveredSignificantBackground = CodeCoverageTextViewer.composeColors(this.fUncoveredLineBackground, this.fCoveredLineBackground, 2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (COVERED_LINES_COLOR_DEF.equals(event.getProperty())) {
            this.fCoveredLineBackground = this.fThemeManager.getCurrentTheme().getColorRegistry().get(COVERED_LINES_COLOR_DEF);
            this.refresh();
        } else if (UNCOVERED_LINES_COLOR_DEF.equals(event.getProperty())) {
            this.fUncoveredLineBackground = this.fThemeManager.getCurrentTheme().getColorRegistry().get(UNCOVERED_LINES_COLOR_DEF);
            this.refresh();
        }
        super.propertyChange(event);
    }

    public void dispose() {
        this.fThemeManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fUncoveredSignificantBackground.dispose();
        super.dispose();
    }

    public void applyStyles() {
        super.applyStyles();
        StyledText text = this.getTextWidget();
        int linesNum = text.getLineCount();
        int line = 0;
        while (line < linesNum) {
            if (this.isLineCovered(line)) {
                text.setLineBackground(line, 1, this.fCoveredLineBackground);
            } else if (this.isLineSignificant(line)) {
                text.setLineBackground(line, 1, this.fUncoveredLineBackground);
            }
            ++line;
        }
    }

    public void setCoverageBitmask(byte[] coverageBitmask) {
        this.fCoverageBitmask = coverageBitmask;
    }

    public void setSingificanceBitmask(byte[] coverageBitmask) {
        this.fSignificanceBitmask = coverageBitmask;
    }

    public void goToNextLine() {
        StyledText text = this.getTextWidget();
        int line = text.getLineAtOffset(text.getCaretOffset());
        int numLines = text.getLineCount();
        while (!this.isLineCovered(++line - 1) && line < numLines) {
        }
        if (line < numLines) {
            text.setSelection(text.getOffsetAtLine(line - 1), text.getOffsetAtLine(line));
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.CodeCoverageTextViewer_1, (String)PHPDebugUIMessages.CodeCoverageTextViewer_2);
        }
    }

    public void goToPreviousLine() {
        StyledText text = this.getTextWidget();
        int line = text.getLineAtOffset(text.getCaretOffset());
        while (!this.isLineCovered(--line - 1) && line > 0) {
        }
        if (line > 0) {
            text.setSelection(text.getOffsetAtLine(line - 1), text.getOffsetAtLine(line));
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.CodeCoverageTextViewer_3, (String)PHPDebugUIMessages.CodeCoverageTextViewer_4);
        }
    }

    private boolean isLineCovered(int line) {
        if (this.fCoverageBitmask.length > ++line / 8) {
            return (this.fCoverageBitmask[line / 8] >> line % 8 & 1) == 1;
        }
        return false;
    }

    private boolean isLineSignificant(int line) {
        if (this.fSignificanceBitmask.length > ++line / 8) {
            return (this.fSignificanceBitmask[line / 8] >> line % 8 & 1) == 1;
        }
        return false;
    }

    private static Color composeColors(Color c1, Color c2, int proportion) {
        int divider = proportion + 1;
        Color newColor = new Color(c1.getDevice(), (proportion * c1.getRed() + c2.getRed()) / divider, (proportion * c1.getGreen() + c2.getGreen()) / divider, (proportion * c1.getBlue() + c2.getBlue()) / divider);
        return newColor;
    }
}

