/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.core.util.collections.IntMap;
import org.eclipse.swt.browser.Browser;

public class PHPSessionLaunchMapper
implements ILaunchesListener {
    private static final String SYSTEM_DEBUG_PROPERTY = "org.eclipse.php.debug.ui.activeDebugging";
    private static PHPSessionLaunchMapper instance;
    private IntHashtable map = new IntHashtable(10);

    private PHPSessionLaunchMapper() {
    }

    private static PHPSessionLaunchMapper getInstance() {
        if (instance == null) {
            instance = new PHPSessionLaunchMapper();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)instance);
        }
        return instance;
    }

    public static void put(int sessionID, ILaunch launch) {
        PHPSessionLaunchMapper.getInstance().map.put(sessionID, (Object)launch);
    }

    public static ILaunch get(int sessionID) {
        return (ILaunch)PHPSessionLaunchMapper.getInstance().map.get(sessionID);
    }

    public static ILaunch remove(int sessionID) {
        return (ILaunch)PHPSessionLaunchMapper.getInstance().map.remove(sessionID);
    }

    public static void updateSystemProperty(ILaunch[] launches) {
        boolean hasActiveLaunch = false;
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            hasActiveLaunch |= !launch.isTerminated();
            ++n2;
        }
        System.setProperty(SYSTEM_DEBUG_PROPERTY, hasActiveLaunch ? "true" : "false");
    }

    public void launchesAdded(ILaunch[] launches) {
        PHPSessionLaunchMapper.updateSystemProperty(launches);
    }

    public void launchesChanged(ILaunch[] launches) {
        PHPSessionLaunchMapper.updateSystemProperty(launches);
    }

    public void launchesRemoved(ILaunch[] launches) {
        IntMap.Entry[] entries = new IntMap.Entry[this.map.size()];
        this.map.entrySet().toArray(entries);
        IntMap.Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IntMap.Entry entry = entryArray[n2];
            ILaunch[] iLaunchArray = launches;
            int n3 = launches.length;
            int n4 = 0;
            while (n4 < n3) {
                ILaunch element = iLaunchArray[n4];
                if (entry.getValue() == element) {
                    this.map.remove(entry.getKey());
                }
                ++n4;
            }
            ++n2;
        }
        PHPSessionLaunchMapper.updateSystemProperty(launches);
        if (this.map.isEmpty()) {
            Browser.clearSessions();
        }
    }
}

