/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.VariablesUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.w3c.dom.Node;

public class DBGpStackFrame
extends DBGpElement
implements IStackFrame {
    private DBGpThread owningThread;
    private String qualifiedFile = "";
    private String stackLevel;
    private String fileName;
    private int lineNo;
    private String name = "";
    private Node descriptor;
    private DBGpVariablesContainer variablesContainer;

    public DBGpStackFrame(DBGpThread threadOwner, Node stackData) {
        super(threadOwner.getDebugTarget());
        this.owningThread = threadOwner;
        this.variablesContainer = new DBGpVariablesContainer();
        this.update(stackData);
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        DBGpLogger.debug(String.valueOf(this.hashCode()) + "::DBGpStackFrame=" + this.lineNo);
        return this.lineNo;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.owningThread;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        DBGpLogger.debug("getting variables for stackframe on line: " + this.lineNo);
        return this.variablesContainer.getVariables();
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables() != null && this.getVariables().length > 0;
    }

    public boolean canStepInto() {
        return this.owningThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.owningThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.owningThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.owningThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.owningThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.owningThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.owningThread.stepReturn();
    }

    public boolean canResume() {
        return this.owningThread.canResume();
    }

    public boolean canSuspend() {
        return this.owningThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.owningThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.owningThread.resume();
    }

    public void suspend() throws DebugException {
        this.owningThread.suspend();
    }

    public boolean canTerminate() {
        return this.owningThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.owningThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.owningThread.terminate();
    }

    public String getSourceName() {
        return this.fileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBGpStackFrame) {
            DBGpStackFrame sf = (DBGpStackFrame)((Object)obj);
            try {
                boolean isEqual = sf.getQualifiedFile().equals(this.getQualifiedFile()) && sf.stackLevel.equals(this.stackLevel) && sf.owningThread == this.owningThread && sf.getLineNumber() == this.getLineNumber();
                return isEqual;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedFile().hashCode() + this.stackLevel.hashCode() + ((Object)((Object)this.owningThread)).hashCode();
    }

    public String getQualifiedFile() {
        return this.qualifiedFile;
    }

    public String getStackLevel() {
        return this.stackLevel;
    }

    protected Node getDescriptor() {
        return this.descriptor;
    }

    protected void update(Node stackData) {
        this.variablesContainer.markToUpdate();
        this.descriptor = stackData;
        String line = DBGpResponse.getAttribute(this.descriptor, "lineno");
        this.stackLevel = DBGpResponse.getAttribute(this.descriptor, "level");
        this.lineNo = Integer.parseInt(line);
        this.qualifiedFile = DBGpUtils.getFilenameFromURIString(DBGpResponse.getAttribute(this.descriptor, "filename"));
        this.qualifiedFile = ((DBGpTarget)this.getDebugTarget()).mapToWorkspaceFileIfRequired(this.qualifiedFile);
        String function = DBGpResponse.getAttribute(this.descriptor, "where");
        IResource fileFound = ResourcesPlugin.getWorkspace().getRoot().findMember(this.qualifiedFile);
        if (fileFound instanceof IFile) {
            IFile file = (IFile)fileFound;
            String projectName = file.getProject().getName();
            String projectRelPath = file.getProjectRelativePath().toString();
            this.fileName = String.valueOf(projectName) + "/" + projectRelPath;
        } else {
            this.fileName = this.qualifiedFile;
        }
        this.name = String.valueOf(this.fileName) + "." + function + "()";
    }

    protected final class DBGpVariablesContainer {
        private Map<String, IVariable> currentVariables;
        private Map<String, IVariable> previousVariables;
        private IVariable[] variables;
        private boolean shouldUpdate = true;

        protected DBGpVariablesContainer() {
        }

        IVariable[] getVariables() {
            if (this.shouldUpdate) {
                this.updateVariables();
                this.variables = this.currentVariables.values().toArray(new IVariable[this.currentVariables.size()]);
                this.shouldUpdate = false;
            }
            return this.variables;
        }

        void markToUpdate() {
            this.shouldUpdate = true;
        }

        private IVariable merge(IVariable variable) {
            if (this.previousVariables == null) {
                return variable;
            }
            if (!(variable instanceof DBGpVariable)) {
                return variable;
            }
            DBGpVariable incoming = (DBGpVariable)variable;
            if (incoming.getFullName().isEmpty()) {
                return incoming;
            }
            IVariable stored = this.previousVariables.get(incoming.getFullName());
            if (stored != null) {
                ((DBGpVariable)stored).update(incoming.getDescriptor());
                return stored;
            }
            return variable;
        }

        private void updateVariables() {
            this.previousVariables = this.currentVariables;
            this.currentVariables = new LinkedHashMap<String, IVariable>();
            Object[] incoming = ((DBGpTarget)DBGpStackFrame.this.getDebugTarget()).getVariables(DBGpStackFrame.this.stackLevel);
            VariablesUtil.sortContextMembers(incoming);
            int i = 0;
            while (i < incoming.length) {
                DBGpVariable variable = (DBGpVariable)incoming[i];
                this.currentVariables.put(variable.getFullName(), this.merge(variable));
                ++i;
            }
        }
    }
}

