/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.php.core.language.ILanguageModelProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.osgi.framework.Bundle;

public class LanguageModelContainer
implements IBuildpathContainer {
    private IPath containerPath;
    private IBuildpathEntry[] buildPathEntries;
    private IScriptProject fProject;

    public LanguageModelContainer(IPath containerPath, IScriptProject project) {
        this.containerPath = containerPath;
        this.fProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
        if (this.buildPathEntries == null) {
            LanguageModelContainer languageModelContainer = this;
            synchronized (languageModelContainer) {
                if (this.buildPathEntries == null) {
                    try {
                        LinkedList<IBuildpathEntry> entries = new LinkedList<IBuildpathEntry>();
                        ILanguageModelProvider[] iLanguageModelProviderArray = LanguageModelInitializer.getContributedProviders();
                        int n = iLanguageModelProviderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILanguageModelProvider provider = iLanguageModelProviderArray[n2];
                            IPath path = provider.getPath(project);
                            if (path != null && (path = this.copyToInstanceLocation(provider, path, project)) != null) {
                                LanguageModelInitializer.addPathName(path, provider.getName());
                                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
                                if (environment != null) {
                                    path = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)path);
                                }
                                entries.add(DLTKCore.newLibraryEntry((IPath)path, (IAccessRule[])IBuildpathEntry.NO_ACCESS_RULES, (IBuildpathAttribute[])IBuildpathEntry.NO_EXTRA_ATTRIBUTES, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (boolean)false, (boolean)true));
                            }
                            ++n2;
                        }
                        this.buildPathEntries = entries.toArray(new IBuildpathEntry[entries.size()]);
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
            }
        }
        return this.buildPathEntries != null ? this.buildPathEntries : new IBuildpathEntry[]{};
    }

    protected IPath copyToInstanceLocation(ILanguageModelProvider provider, IPath path, IScriptProject project) {
        try {
            boolean update;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("$nl$", Platform.getNL());
            URL url = FileLocator.find((Bundle)provider.getPlugin().getBundle(), (IPath)provider.getPath(project), map);
            File sourceFile = new File(FileLocator.toFileURL((URL)url).getPath());
            LocalFile sourceDir = new LocalFile(sourceFile.getCanonicalFile());
            IPath targetPath = LanguageModelInitializer.getTargetLocation(provider, Path.fromOSString((String)sourceFile.getAbsolutePath()), project);
            LocalFile targetDir = new LocalFile(targetPath.toFile());
            IFileInfo targetInfo = targetDir.fetchInfo();
            boolean bl = update = !targetInfo.exists();
            if (!update) {
                IFileInfo sourceInfo = sourceDir.fetchInfo();
                boolean bl2 = update = targetInfo.getLastModified() < sourceInfo.getLastModified();
            }
            if (update) {
                targetDir.delete(0, (IProgressMonitor)new NullProgressMonitor());
                sourceDir.copy((IFileStore)targetDir, 0, (IProgressMonitor)new NullProgressMonitor());
            }
            return targetPath;
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    public String getDescription() {
        return "PHP Language Library";
    }

    public int getKind() {
        return 2;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public IBuildpathEntry[] getBuildpathEntries() {
        return this.getBuildpathEntries(this.fProject);
    }
}

