/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalMethodStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.KeywordsStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public class MethodKeywordStrategy
extends KeywordsStrategy {
    public MethodKeywordStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public MethodKeywordStrategy(ICompletionContext context) {
        super(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean filterKeyword(PHPKeywords.KeywordData keyword) {
        ICompletionContext context;
        if ((keyword.context & 2) != 0 && this.isParent(keyword) && (context = this.getContext()) instanceof GlobalMethodStatementContext) {
            GlobalMethodStatementContext globalContext = (GlobalMethodStatementContext)context;
            IType type = globalContext.getEnclosingType();
            try {
                IType[] superTypes;
                if (type == null) return true;
                if (!PHPFlags.isClass(type.getFlags())) return true;
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(type, null);
                IType[] iTypeArray = superTypes = hierarchy.getAllSupertypes(type);
                int n = superTypes.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return true;
                    }
                    IType superType = iTypeArray[n2];
                    if (PHPFlags.isClass(superType.getFlags())) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (ModelException modelException) {}
            return true;
        }
        if ((keyword.context & 2) != 0) return false;
        return true;
    }

    protected boolean isParent(PHPKeywords.KeywordData keyword) {
        String name = keyword.name;
        if (PHPVersion.PHP5_4.isLessThan(this.getCompanion().getPHPVersion())) {
            name = name.toLowerCase();
        }
        return name.equals("parent");
    }
}

