/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.api.packages.PharDownloader;
import org.eclipse.php.composer.core.launch.ExecutableNotFoundException;
import org.eclipse.php.composer.core.launch.ScriptLauncher;
import org.eclipse.php.composer.core.launch.ScriptLauncherManager;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPlugin;
import org.eclipse.php.composer.ui.handler.ConsoleResponseHandler;
import org.eclipse.php.composer.ui.job.runner.MissingExecutableRunner;
import org.eclipse.php.composer.ui.wizard.AbstractWizardFirstPage;
import org.eclipse.php.composer.ui.wizard.Messages;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.ui.wizards.IPHPProjectCreateWizardPage;
import org.eclipse.php.internal.ui.wizards.PHPBuildpathDetector;
import org.eclipse.php.ui.util.PHPProjectUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class AbstractWizardSecondPage
extends CapabilityConfigurationPage
implements IPHPProjectCreateWizardPage,
Observer {
    protected final AbstractWizardFirstPage firstPage;
    protected Boolean fIsAutobuild;
    protected ScriptLauncher launcher;
    protected PharDownloader downloader;
    protected URI currentProjectLocation;
    @Inject
    protected ScriptLauncherManager launchManager;

    public AbstractWizardSecondPage(AbstractWizardFirstPage mainPage, String title) {
        super(title);
        this.setPageComplete(false);
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        this.firstPage = mainPage;
        this.fIsAutobuild = null;
        this.currentProjectLocation = null;
        ContextInjectionFactory.inject((Object)this, (IEclipseContext)ComposerUIPlugin.getDefault().getEclipseContext());
    }

    public void initPage() {
        this.changeToNewProject();
    }

    protected String getScriptNature() {
        return "org.eclipse.php.core.PHPNature";
    }

    protected void changeToNewProject() {
        this.firstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (AbstractWizardSecondPage.this.fIsAutobuild == null) {
                            AbstractWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild((boolean)false);
                        }
                        AbstractWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void dumpAutoload(IProgressMonitor monitor) throws Exception {
        try {
            this.launcher = this.launchManager.getLauncher("org.eclipse.php.composer.core.launcherfactory", this.getProject());
        }
        catch (ExecutableNotFoundException executableNotFoundException) {
            Display.getDefault().asyncExec((Runnable)new MissingExecutableRunner());
            return;
        }
        this.launcher.addResponseListener((ExecutionResponseListener)new ConsoleResponseHandler());
        try {
            this.launcher.launch("dumpautoload");
            this.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    protected void installComposer(IProgressMonitor monitor) throws CoreException {
        IPreferenceStore prefs = ComposerUIPlugin.getDefault().getCorePreferenceStore();
        if (prefs.getBoolean("org.eclipse.php.composer.coreuse_project_phar")) {
            this.downloader = new PharDownloader();
            InputStream resource = this.downloader.download();
            IFile file = this.getProject().getFile("composer.phar");
            file.create(resource, true, monitor);
            file.refreshLocal(0, monitor);
        }
    }

    protected void addComposerJson(IProgressMonitor monitor) throws CoreException {
        IFile file = this.getProject().getFile("composer.json");
        Namespace ns = this.firstPage.getPackage().getAutoload().getPsr4().getFirst();
        if (ns != null) {
            Path path = new Path("src");
            IFolder folder = this.getProject().getFolder((IPath)path);
            if (!folder.exists()) {
                folder.create(false, true, monitor);
            }
        }
        if (file.exists()) {
            Logger.debug((String)"composer.json already exists in the location");
            return;
        }
        ComposerPackage composerPackage = this.firstPage.getPackage();
        VersionedPackage phpVersion = new VersionedPackage();
        phpVersion.setName("php");
        phpVersion.setVersion(">=" + this.firstPage.getPHPVersionValue().getAlias().replace("php", ""));
        composerPackage.getRequire().add(phpVersion);
        ByteArrayInputStream bis = new ByteArrayInputStream(composerPackage.toJson().getBytes());
        file.create((InputStream)bis, true, monitor);
        this.getProject().refreshLocal(0, monitor);
    }

    protected void setPhpLangOptions() {
        boolean useASPTags = this.firstPage.versionGroup.fConfigurationBlock.getUseAspTagsValue();
        PHPVersion phpVersion = this.firstPage.versionGroup.fConfigurationBlock.getPHPVersionValue();
        ProjectOptions.setSupportingASPTags((boolean)useASPTags, (IProject)this.getProject());
        ProjectOptions.setPHPVersion((PHPVersion)phpVersion, (IProject)this.getProject());
    }

    protected URI getProjectLocationURI() throws CoreException {
        if (this.firstPage.isInWorkspace()) {
            return null;
        }
        return this.firstPage.getLocationURI();
    }

    protected IProject getProject() {
        IScriptProject scriptProject = this.getScriptProject();
        if (scriptProject != null) {
            return scriptProject.getProject();
        }
        return null;
    }

    public void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        PHPProjectUtils.createProjectAt((IProject)project, (URI)locationURI, (String)this.getScriptNature(), (IProgressMonitor)monitor);
    }

    public IProject getCurrProject() {
        return this.getProject();
    }

    protected IncludePath[] setProjectBaseIncludepath() {
        return new IncludePath[]{new IncludePath((Object)this.getProject(), this.getProject())};
    }

    protected BuildpathDetector createBuildpathDetector(IProgressMonitor monitor, IDLTKLanguageToolkit toolkit) throws CoreException {
        PHPBuildpathDetector detector = new PHPBuildpathDetector(this.getProject(), toolkit);
        detector.detectBuildpath((IProgressMonitor)new SubProgressMonitor(monitor, 20));
        return detector;
    }

    public void cancel() {
        if (this.downloader != null) {
            this.downloader.abort();
        }
    }

    protected void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IProject projectHandle = this.firstPage.getProjectHandle();
        IScriptProject create = DLTKCore.create((IProject)projectHandle);
        super.init(create, null, false);
        this.currentProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.AbstractWizardSecondPage_InitializingProjectTaskName, 70);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createProject(this.getProject(), this.currentProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            IBuildpathEntry[] buildpathEntries = null;
            Path srcPath = new Path("src");
            if (srcPath.segmentCount() > 0) {
                IFolder folder = this.getProject().getFolder((IPath)srcPath);
                CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            } else {
                monitor.worked(10);
            }
            IPath projectPath = this.getProject().getFullPath();
            ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
            cpEntries.add(DLTKCore.newContainerEntry((IPath)LanguageModelInitializer.LANGUAGE_CONTAINER_PATH));
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append("vendor").append("composer")));
            buildpathEntries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(DLTKCore.create((IProject)this.getProject()), buildpathEntries, false);
            this.setPhpLangOptions();
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 30));
            this.getScriptProject().setRawBuildpath(buildpathEntries, (IProgressMonitor)new NullProgressMonitor());
            LanguageModelInitializer.enableLanguageModelFor((IScriptProject)this.getScriptProject());
        }
        finally {
            monitor.done();
        }
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 5;
        monitor.beginTask(NewWizardMessages.ScriptCapabilityConfigurationPage_op_desc_Script, nSteps);
        try {
            try {
                IProject project = this.getScriptProject().getProject();
                this.configureProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            try {
                this.beforeFinish(monitor);
                monitor.beginTask(Messages.AbstractWizardSecondPage_InitializingBuildPathsTaskName, 10);
                if (this.getProject() == null || !this.getProject().exists()) {
                    this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
                }
                this.finishPage(monitor);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                monitor.done();
                if (this.fIsAutobuild != null) {
                    CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
        }
        finally {
            monitor.done();
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    protected void refreshProject(String projectName) {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            Logger.log((int)3, (String)("Error finishing create-project installation. Could not obtain project from workspace: " + projectName));
            return;
        }
        new WorkspaceJob(NLS.bind((String)Messages.AbstractWizardSecondPage_RefreshingProjectJobName, (Object)projectName)){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    public abstract void update(Observable var1, Object var2);

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected abstract void beforeFinish(IProgressMonitor var1) throws Exception;

    protected abstract void finishPage(IProgressMonitor var1) throws Exception;
}

