/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.objects.Script;
import org.eclipse.php.composer.ui.controller.ScriptsController;
import org.eclipse.php.composer.ui.dialogs.ScriptDialog;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.TreeSection;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.parts.TreePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ScriptsSection
extends TreeSection
implements PropertyChangeListener {
    private TreeViewer scriptsViewer;
    private IAction addAction;
    private IAction editAction;
    private IAction removeAction;
    private static final int ADD_INDEX = 0;
    private static final int EDIT_INDEX = 1;
    private static final int REMOVE_INDEX = 2;

    public ScriptsSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{Messages.ScriptsSection_AddButton, Messages.ScriptsSection_EditButton, Messages.ScriptsSection_RemoveButton});
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(Messages.ScriptsSection_Title);
        section.setDescription(Messages.ScriptsSection_Description);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 4, 2, toolkit);
        TreePart treePart = this.getTreePart();
        ScriptsController scriptsController = new ScriptsController(treePart.getTreeViewer());
        this.scriptsViewer = treePart.getTreeViewer();
        this.scriptsViewer.setUseHashlookup(true);
        this.scriptsViewer.setContentProvider((IContentProvider)scriptsController);
        this.scriptsViewer.setLabelProvider((IBaseLabelProvider)scriptsController);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        this.scriptsViewer.setInput((Object)this.composerPackage.getScripts());
        this.composerPackage.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateButtons();
        this.makeActions();
        this.updateMenu();
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void updateButtons() {
        ISelection selection = this.scriptsViewer.getSelection();
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, this.enabled);
        treePart.setButtonEnabled(1, !selection.isEmpty() && !(((StructuredSelection)selection).getFirstElement() instanceof Script) && this.enabled);
        treePart.setButtonEnabled(2, !selection.isEmpty() && this.enabled);
    }

    private void updateMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.scriptsViewer.getSelection();
        this.editAction.setEnabled(selection.size() > 0);
        this.removeAction.setEnabled(selection.size() > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.refresh();
        this.scriptsViewer.getTree().setEnabled(enabled);
    }

    public void refresh() {
        this.scriptsViewer.refresh();
        super.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().startsWith("scripts")) {
            this.refresh();
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.updateButtons();
        this.updateMenu();
    }

    private void makeActions() {
        this.addAction = new Action(Messages.ScriptsSection_AddActionTitle){

            public void run() {
                ScriptsSection.this.handleAdd();
            }
        };
        this.editAction = new Action(Messages.ScriptsSection_EditActionTitle){

            public void run() {
                ScriptsSection.this.handleEdit();
            }
        };
        this.removeAction = new Action(Messages.ScriptsSection_RemoveActionTitle){

            public void run() {
                ScriptsSection.this.handleRemove();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.addAction);
        manager.add(this.editAction);
        manager.add(this.removeAction);
    }

    private void handleAdd() {
        Script script = null;
        Object element = ((StructuredSelection)this.scriptsViewer.getSelection()).getFirstElement();
        if (element instanceof Script.HandlerValue) {
            element = ((ScriptsController)this.scriptsViewer.getContentProvider()).getParent(element);
        }
        if (element instanceof Script) {
            script = (Script)element;
        }
        Script dialogScript = new Script(script != null ? script.getScript() : null, new Script.HandlerValue(""));
        ScriptDialog dialog = new ScriptDialog(this.scriptsViewer.getTree().getShell(), dialogScript, dialogScript.getFirst());
        if (dialog.open() == 0 && dialog.getScript().getScript() != null) {
            assert (dialogScript == dialog.getScript());
            this.composerPackage.getScripts().add(dialog.getScript());
        }
    }

    private void handleEdit() {
        Script script = null;
        int index = -1;
        Object element = ((StructuredSelection)this.scriptsViewer.getSelection()).getFirstElement();
        if (element instanceof Script.HandlerValue) {
            element = ((ScriptsController)this.scriptsViewer.getContentProvider()).getParent(element);
            TreeItem selectedItem = this.scriptsViewer.getTree().getSelection()[0];
            TreeItem[] items = selectedItem.getParentItem().getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] == selectedItem) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (element instanceof Script) {
            script = (Script)element;
        }
        if (script != null && index != -1) {
            assert (index < script.size());
            Script dialogScript = script.clone();
            ScriptDialog dialog = new ScriptDialog(this.scriptsViewer.getTree().getShell(), dialogScript, dialogScript.get(index));
            dialog.setEventEnabled(false);
            if (dialog.open() == 0) {
                assert (dialogScript == dialog.getScript());
                Script cpscript = (Script)this.composerPackage.getScripts().get(script.getScript());
                if (cpscript.equals((Object)dialog.getScript())) {
                    return;
                }
                assert (cpscript.getScript() != null && cpscript.getScript().equals(dialog.getScript().getScript()));
                cpscript.clear();
                cpscript.addHandlers(dialog.getScript());
            }
        }
    }

    private void handleRemove() {
        Object element = ((StructuredSelection)this.scriptsViewer.getSelection()).getFirstElement();
        ScriptsController controller = (ScriptsController)this.scriptsViewer.getLabelProvider();
        if (element instanceof Script) {
            String text = controller.getText(element);
            MessageDialog diag = new MessageDialog(this.scriptsViewer.getTree().getShell(), Messages.ScriptsSection_RemoveEventDialogTitle, null, NLS.bind((String)Messages.ScriptsSection_RemoveEventDialogMessage, (Object)text), 4, new String[]{Messages.ScriptsSection_YesButton, Messages.ScriptsSection_NoButton}, 0);
            if (diag.open() == 0) {
                this.composerPackage.getScripts().remove((Script)element);
            }
        } else if (element instanceof Script.HandlerValue) {
            String text = controller.getText(element);
            Script script = (Script)((ScriptsController)this.scriptsViewer.getContentProvider()).getParent(element);
            if (script != null) {
                int index = -1;
                TreeItem selectedItem = this.scriptsViewer.getTree().getSelection()[0];
                TreeItem[] items = selectedItem.getParentItem().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] == selectedItem) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                assert (index != -1 && index < script.size());
                String event = controller.getText(script);
                MessageDialog diag = new MessageDialog(this.scriptsViewer.getTree().getShell(), Messages.ScriptsSection_RemoveHandlerDialogTitle, null, NLS.bind((String)Messages.ScriptsSection_RemoveHandlerDialogMessage, (Object)text, (Object)event), 4, new String[]{Messages.ScriptsSection_YesButton, Messages.ScriptsSection_NoButton}, 0);
                if (diag.open() == 0) {
                    script.remove(index);
                }
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }
}

