/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.objects;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.entities.AbstractJsonObject;
import org.eclipse.php.composer.api.entities.JsonValue;
import org.eclipse.php.composer.api.json.ParseException;

public class JsonObject
extends AbstractJsonObject<JsonValue> {
    public JsonObject() {
        this.listen();
    }

    public JsonObject(Object json) {
        this();
        this.fromJson(json);
    }

    public JsonObject(String json) throws ParseException {
        this();
        this.fromJson(json);
    }

    public JsonObject(File file) throws IOException, ParseException {
        this();
        this.fromJson(file);
    }

    public JsonObject(Reader reader) throws IOException, ParseException {
        this();
        this.fromJson(reader);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public boolean is(String property, Type type) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).is(type);
        }
        return false;
    }

    public boolean isArray(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).isArray();
        }
        return false;
    }

    public boolean isObject(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).isObject();
        }
        return false;
    }

    public Object getAsRaw(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).getAsRaw();
        }
        return null;
    }

    public JsonArray getAsArray(String property) {
        if (!super.has(property)) {
            super.set(property, new JsonValue(new JsonArray()), false);
        }
        return ((JsonValue)this.get(property)).getAsArray();
    }

    public String getAsString(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).getAsString();
        }
        return null;
    }

    public Boolean getAsBoolean(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).getAsBoolean();
        }
        return null;
    }

    public Integer getAsInteger(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).getAsInteger();
        }
        return null;
    }

    public Float getAsFloat(String property) {
        if (super.has(property)) {
            return ((JsonValue)this.get(property)).getAsFloat();
        }
        return null;
    }

    public JsonObject getAsObject(String property) {
        if (!super.has(property)) {
            super.set(property, new JsonValue(new JsonObject()), false);
        }
        return ((JsonValue)this.get(property)).getAsObject();
    }

    @Override
    public void set(String property, Object value) {
        super.set(property, new JsonValue(value));
    }

    protected void cloneProperties(JsonObject clone) {
        for (Map.Entry entry : this.properties.entrySet()) {
            clone.set((String)entry.getKey(), ((JsonValue)entry.getValue()).getAsRaw());
        }
    }
}

