/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemView;
import org.eclipse.photran.internal.ui.vpg.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.osgi.framework.Bundle;

public class VPGProblemLabelProvider
implements ITableLabelProvider {
    private static final String NAME_PREFIX = "icons/full/obj16/";
    private static final String IMG_OBJS_REFACTORING_FATAL = "icons/full/obj16/fatalerror_obj.gif";
    private static final String IMG_OBJS_REFACTORING_ERROR = "icons/full/obj16/error_obj.gif";
    private static final String IMG_OBJS_REFACTORING_WARNING = "icons/full/obj16/warning_obj.gif";
    private static final String IMG_OBJS_REFACTORING_INFO = "icons/full/obj16/info_obj.gif";
    private static final Map<String, Image> images = new HashMap<String, Image>();

    private static Image getImage(String key) {
        if (!images.containsKey(key)) {
            Path projectRelativePath = new Path(key);
            URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)projectRelativePath, null);
            if (url == null) {
                Exception e = new Exception("Missing image: " + key);
                Activator.log(e.getMessage(), e);
            }
            images.put(key, ImageDescriptor.createFromURL((URL)url).createImage());
        }
        return images.get(key);
    }

    public Image getColumnImage(Object obj, int colIndex) {
        if (colIndex != VPGProblemView.VPGViewColumn.DESCRIPTION.ordinal()) {
            return null;
        }
        switch (MarkerUtilities.getSeverity((IMarker)((IMarker)obj))) {
            case 0: {
                return VPGProblemLabelProvider.getImage(IMG_OBJS_REFACTORING_INFO);
            }
            case 1: {
                return VPGProblemLabelProvider.getImage(IMG_OBJS_REFACTORING_WARNING);
            }
            case 2: {
                return VPGProblemLabelProvider.getImage(IMG_OBJS_REFACTORING_ERROR);
            }
        }
        return null;
    }

    public String getColumnText(Object item, int index) {
        if (item instanceof IMarker) {
            IMarker marker = (IMarker)item;
            switch (VPGProblemView.VPGViewColumn.values()[index]) {
                case DESCRIPTION: {
                    return MarkerUtilities.getMessage((IMarker)marker);
                }
                case RESOURCE: {
                    return marker.getResource().getName().toString();
                }
                case PATH: {
                    return marker.getResource().getProjectRelativePath().toString();
                }
            }
        }
        return null;
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }
}

