/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.photran.internal.core.lexer.CPreprocessingReader;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;

public class DisplayPreprocessedSource
extends FortranEditorActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            boolean isFixedForm = this.getFortranEditor().isFixedForm();
            IDocument doc = this.getFortranEditor().getIDocument();
            StringReader in = new StringReader(doc.get());
            CPreprocessingReader cppIn = new CPreprocessingReader(this.getFortranEditor().getIFile(), null, (Reader)in);
            try {
                File tempFile = File.createTempFile("tmp", isFixedForm ? ".f" : ".f90");
                tempFile.deleteOnExit();
                PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
                try {
                    int c = cppIn.read();
                    while (c != -1) {
                        out.print((char)c);
                        c = cppIn.read();
                    }
                }
                finally {
                    out.close();
                }
                IDE.openEditor((IWorkbenchPage)Workbench.getInstance().getActiveWorkbenchWindow().getActivePage(), (URI)tempFile.toURI(), (String)"org.eclipse.photran.ui.FortranEditor", (boolean)true);
            }
            finally {
                cppIn.close();
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
        }
    }
}

