/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTNodeUtil;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;

public class ASTListNode<T extends IASTNode>
extends ArrayList<T>
implements IASTListNode<T> {
    private IASTNode parent = null;

    public ASTListNode() {
    }

    public ASTListNode(int initialCapacity) {
        super(initialCapacity);
    }

    public ASTListNode(T singletonElement) {
        super(1);
        this.add(singletonElement);
    }

    public ASTListNode(T ... elements) {
        super(elements.length);
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            this.add(e);
            ++n2;
        }
    }

    public ASTListNode(Collection<? extends T> copyFrom) {
        super(copyFrom);
    }

    public ASTListNode(T first, Collection<? extends T> rest) {
        super(rest.size() + 1);
        this.add(first);
        this.addAll((Collection<? extends T>)rest);
    }

    public ASTListNode(Collection<? extends T> firsts, T last) {
        super(firsts.size() + 1);
        this.addAll((Collection<? extends T>)firsts);
        this.add(last);
    }

    @Override
    public void insertBefore(T insertBefore, T newElement) {
        int index = this.indexOf(insertBefore);
        if (index < 0) {
            throw new IllegalArgumentException("Element to insert before not in list");
        }
        this.add(index, newElement);
    }

    @Override
    public void insertAfter(T insertAfter, T newElement) {
        int index = this.indexOf(insertAfter);
        if (index < 0) {
            throw new IllegalArgumentException("Element to insert after not in list");
        }
        this.add(index + 1, newElement);
    }

    @Override
    public IASTNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IASTNode parent) {
        this.parent = parent;
    }

    @Override
    public Iterable<? extends IASTNode> getChildren() {
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return new ASTNodeUtil.NonNullIterator(new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ASTListNode.this.size();
            }

            @Override
            public T next() {
                return this.index >= ASTListNode.this.size() ? null : (IASTNode)ASTListNode.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visitASTNode(this);
        visitor.visitASTListNode(this);
    }

    @Override
    public <T extends IASTNode> Set<T> findAll(Class<T> targetClass) {
        return ASTNodeUtil.findAll(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findNearestAncestor(Class<T> targetClass) {
        return ASTNodeUtil.findNearestAncestor(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findFirst(Class<T> targetClass) {
        return ASTNodeUtil.findFirst(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findLast(Class<T> targetClass) {
        return ASTNodeUtil.findLast(this, targetClass);
    }

    @Override
    public Token findFirstToken() {
        return ASTNodeUtil.findFirstToken(this);
    }

    @Override
    public Token findLastToken() {
        return ASTNodeUtil.findLastToken(this);
    }

    @Override
    public boolean isFirstChildInList() {
        return ASTNodeUtil.isFirstChildInList(this);
    }

    @Override
    public T set(int index, T element) {
        if (element != null) {
            element.setParent(this);
        }
        return (T)((IASTNode)super.set(index, element));
    }

    @Override
    public boolean add(T element) {
        if (element != null) {
            element.setParent(this);
        }
        return super.add(element);
    }

    @Override
    public void add(int index, T element) {
        if (element != null) {
            element.setParent(this);
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (IASTNode element : c) {
            if (element == null) continue;
            element.setParent(this);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (IASTNode element : c) {
            if (element == null) continue;
            element.setParent(this);
        }
        return super.addAll(index, c);
    }

    @Override
    public void replaceChild(IASTNode node, IASTNode withNode) {
        int i = this.indexOf(node);
        if (i < 0) {
            throw new IllegalStateException("Child node not found");
        }
        this.set(i, (T)withNode);
        if (withNode != null) {
            withNode.setParent(this);
        }
    }

    @Override
    public void removeFromTree() {
        ASTNodeUtil.removeFromTree(this);
    }

    @Override
    public void replaceWith(IASTNode newNode) {
        ASTNodeUtil.replaceWith((IASTNode)this, newNode);
    }

    @Override
    public void replaceWith(String literalString) {
        ASTNodeUtil.replaceWith((IASTNode)this, literalString);
    }

    @Override
    public Object clone() {
        ASTListNode<IASTNode> copy = new ASTListNode<IASTNode>();
        for (IASTNode n : this) {
            if (n == null) {
                copy.add(null);
                continue;
            }
            IASTNode newChild = (IASTNode)n.clone();
            newChild.setParent(copy);
            copy.add(newChild);
        }
        return copy;
    }

    @Override
    public IPreprocessorReplacement printOn(PrintStream out, IPreprocessorReplacement currentPreprocessorDirective) {
        return ASTNodeUtil.print(this, currentPreprocessorDirective, out);
    }

    @Override
    public String toString() {
        return ASTNodeUtil.toString(this);
    }
}

