/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.LineAppendingReader;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.FortranIncludeDirective;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.FortranPreprocessor;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;

public class PreprocessingFixedFormLexerPhase1
extends FreeFormLexerPhase1 {
    private FortranPreprocessor preprocessor;
    private FortranIncludeDirective lastDirective;

    public PreprocessingFixedFormLexerPhase1(Reader in, IFile file, String filename, IncludeLoaderCallback callback, boolean accumulateWhitetext) throws IOException {
        this(new FortranPreprocessor(new LineAppendingReader(in), file, filename, callback), file, filename, accumulateWhitetext);
    }

    private PreprocessingFixedFormLexerPhase1(FortranPreprocessor preprocessor, IFile file, String filename, boolean accumulateWhitetext) {
        super(preprocessor, file, filename, accumulateWhitetext);
        this.preprocessor = preprocessor;
        this.lastDirective = null;
    }

    @Override
    public Token yylex() throws IOException, LexerException {
        Token token = (Token)super.yylex();
        FortranIncludeDirective thisDirective = this.preprocessor.getDirectiveAtOffset(this.lastTokenStreamOffset);
        if (thisDirective != null && this.lastDirective == null) {
            this.adjustWhiteBeforeAtIncludeStart(token);
        } else if (thisDirective == null && this.lastDirective != null) {
            this.adjustWhiteBeforeAtIncludeEnd(token);
        }
        token.setPreprocessorDirective(thisDirective);
        this.lastDirective = thisDirective;
        this.lastTokenFileOffset = this.preprocessor.getFileOffsetFromStreamOffset(this.lastTokenStreamOffset);
        this.lastTokenLine = this.preprocessor.getFileLineFromStreamLine(this.lastTokenLine);
        return token;
    }

    private void adjustWhiteBeforeAtIncludeStart(Token token) {
        int fileStartOffset = this.preprocessor.getStartOffsetOfFileContainingStreamOffset(this.lastTokenStreamOffset);
        int tokenTextStartOffset = this.lastTokenStreamOffset;
        String whiteBefore = token.getWhiteBefore();
        int charsFromIncludeFile = tokenTextStartOffset - fileStartOffset;
        if (charsFromIncludeFile > 0) {
            int charsToKeep = whiteBefore.length() - charsFromIncludeFile;
            charsToKeep = Math.max(charsToKeep, 0);
            token.setWhiteBefore(whiteBefore.substring(0, charsToKeep));
        }
    }

    private void adjustWhiteBeforeAtIncludeEnd(Token token) {
        int fileStartOffset = this.preprocessor.getStartOffsetOfFileContainingStreamOffset(this.lastTokenStreamOffset);
        int tokenTextStartOffset = this.lastTokenStreamOffset;
        String whiteBefore = token.getWhiteBefore();
        int charsFromRealFile = tokenTextStartOffset - fileStartOffset;
        int charsToTrim = whiteBefore.length() - charsFromRealFile;
        charsToTrim = Math.max(charsToTrim, 0);
        token.setWhiteBefore(whiteBefore.substring(charsToTrim));
    }

    @Override
    public void yypushback(int number) {
        throw new UnsupportedOperationException();
    }
}

