/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTImplicitSpecNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

public class ImplicitSpec
implements IPhotranSerializable {
    private static final long serialVersionUID = 1L;
    private String toString = "Implicit Enabled - Default Implicit Spec: real (a-h), integer (i-n), real (o-z)";
    private Type[] typeMap = new Type[]{Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.INTEGER, Type.INTEGER, Type.INTEGER, Type.INTEGER, Type.INTEGER, Type.INTEGER, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL, Type.REAL};

    public ImplicitSpec() {
    }

    public ImplicitSpec(IASTListNode<ASTImplicitSpecNode> implicitSpecList) {
        this.toString = "Implicit Enabled -" + ImplicitSpec.getSourceCodeFromASTNode(implicitSpecList);
        implicitSpecList.accept(new ASTVisitor(){

            @Override
            public void visitASTImplicitSpecNode(ASTImplicitSpecNode implicitSpec) {
                Type type = Type.parse(implicitSpec.getTypeSpec());
                Token impl = implicitSpec.getCharRanges();
                this.setRangesToType(impl, type);
            }

            private void setRangesToType(Token txImpl, Type type) {
                String[] ranges;
                String rangeList = txImpl.getText().replaceAll("[ \t]", "");
                rangeList = rangeList.substring(1, rangeList.length() - 1);
                String[] stringArray = ranges = rangeList.split(",");
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    String range = stringArray[n2];
                    this.setRangeToType(range, type);
                    ++n2;
                }
            }

            private void setRangeToType(String range, Type type) {
                char rangeStart = range.charAt(0);
                char rangeEnd = range.length() == 3 ? range.charAt(2) : rangeStart;
                char letter = rangeStart;
                while (letter <= rangeEnd) {
                    ImplicitSpec.this.setType(letter, type);
                    letter = (char)(letter + '\u0001');
                }
            }
        });
    }

    public ImplicitSpec(ImplicitSpec original) {
        this.typeMap = original == null || original.typeMap == null ? null : (Type[])original.typeMap.clone();
    }

    public void setType(char letter, Type type) {
        if (!Character.isLetter(letter)) {
            return;
        }
        letter = Character.toUpperCase(letter);
        this.typeMap[letter - 65] = type;
    }

    public Type getType(char letter) {
        if (!Character.isLetter(letter)) {
            return Type.REAL;
        }
        letter = Character.toUpperCase(letter);
        return this.typeMap[letter - 65];
    }

    private static String getSourceCodeFromASTNode(IASTNode node) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        node.printOn(new PrintStream(out), null);
        return out.toString();
    }

    public String toString() {
        return this.toString;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.toString, out);
        int i = 0;
        while (i < this.typeMap.length) {
            PhotranVPGSerializer.serialize(this.typeMap[i], out);
            ++i;
        }
    }

    public static ImplicitSpec readFrom(InputStream in) throws IOException {
        ImplicitSpec result = new ImplicitSpec();
        result.toString = (String)PhotranVPGSerializer.deserialize(in);
        int i = 0;
        while (i < result.typeMap.length) {
            result.typeMap[i] = (Type)PhotranVPGSerializer.deserialize(in);
            ++i;
        }
        return result;
    }

    @Override
    public char getSerializationCode() {
        return 'I';
    }
}

