/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.cheatsheet;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPluginImages;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.CSFileWizardPage;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.CSWizardMessages;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.CompCSCreationOperation;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.SimpleCSCreationOperation;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewCSFileWizard
extends BasicNewFileResourceWizard {
    protected CSFileWizardPage fMainPage;

    public void addPages() {
        this.fMainPage = new CSFileWizardPage("cheatsheet", this.getSelection());
        this.addPage((IWizardPage)this.fMainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(CSWizardMessages.NewCSFileWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PDEUserAssistanceUIPluginImages.DESC_CHEATSHEET_WIZ);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, this.getOperation());
        }
        catch (InvocationTargetException e) {
            PDEUserAssistanceUIPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IRunnableWithProgress getOperation() {
        IFile file = this.fMainPage.createNewFile();
        int option = this.fMainPage.getCheatSheetType();
        if (option == 0) {
            return new SimpleCSCreationOperation(file);
        }
        if (option == 1) {
            return new CompCSCreationOperation(file);
        }
        return null;
    }
}

