/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.Path;

public class PluginPathFinder {
    private static String getSitePath(String platformHome, File linkFile, boolean features) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream fis = new FileInputStream(linkFile);){
                properties.load(fis);
                String path = properties.getProperty("path");
                if (path != null) {
                    if (!new Path(path).isAbsolute()) {
                        path = String.valueOf(prefix) + '/' + path;
                    }
                    path = String.valueOf(path) + "/eclipse/";
                    path = features ? String.valueOf(path) + "features" : String.valueOf(path) + "plugins";
                    if (new File(path).exists()) {
                        return path;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static File[] getSites(String platformHome, boolean features) {
        File[] linkFiles;
        HashSet<File> sites = new HashSet<File>();
        File file = new File(platformHome, features ? "features" : "plugins");
        if (!features && !file.exists()) {
            file = new File(platformHome);
        }
        if (file.exists()) {
            sites.add(file);
        }
        if ((linkFiles = new File(String.valueOf(platformHome) + '/' + "links").listFiles()) != null) {
            File[] fileArray = linkFiles;
            int n = linkFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File linkFile = fileArray[n2];
                String path = PluginPathFinder.getSitePath(platformHome, linkFile, features);
                if (path != null) {
                    sites.add(new File(path));
                }
                ++n2;
            }
        }
        if (sites.isEmpty() && (file = new File(platformHome)).exists()) {
            sites.add(file);
        }
        return sites.toArray(new File[sites.size()]);
    }

    public static URL[] getFeaturePaths(String platformHome) {
        return PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome, true));
    }

    public static URL[] scanLocations(File[] sites) {
        HashSet<URL> result = new HashSet<URL>();
        int i = 0;
        while (i < sites.length) {
            File[] children;
            if (sites[i].exists() && (children = sites[i].listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File element = fileArray[n2];
                    try {
                        result.add(element.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++n2;
                }
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }
}

