/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.widgets.providers.IDependableLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalLabelProvider;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.messages.Messages;
import org.eclipse.papyrus.uml.tools.profile.definition.LabelStylersEnum;
import org.eclipse.papyrus.uml.tools.profile.definition.LabelTypesEnum;
import org.eclipse.papyrus.uml.tools.providers.CustomizableDelegatingItemLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.uml2.uml.Element;

public class FlatTabUMLLabelProvider
implements IGraphicalLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IDependableLabelProvider {
    private static final String CUSTOMIZED_STYLES_PREF_KEY = "CustomizedStyles";
    private static final String CUSTOMIZED_TYPES_PREF_KEY = "CustomizedTypes";
    private static final String MODELEXPLORER_BUNDLE_NAME = "org.eclipse.papyrus.uml.modelexplorer";
    private static final String ICON_QUALIFIED_NAME = "/icons/QualifiedName.png";
    private static final CustomizableDelegatingItemLabelProvider umllabelProvider = new CustomizableDelegatingItemLabelProvider();
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
    private boolean displayQualifiedName = false;
    private List<String> types = new ArrayList<String>();
    private List<StyledString.Styler> stylers = new ArrayList<StyledString.Styler>();
    private ILabelProvider provider;
    private ToolBar Toolbar;
    protected static final String DIALOG_SETTINGS_KEY = FlatTabUMLLabelProvider.class.getName();
    private static final String DISPLAY_QUALIFIED_NAME_PREF_KEY = "displayQualifiedName";

    public FlatTabUMLLabelProvider() {
        this.initializeDialogsSettings();
    }

    protected void initializeDialogsSettings() {
        this.displayQualifiedName = this.getDialogSettings().getBoolean(DISPLAY_QUALIFIED_NAME_PREF_KEY);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public StyledString getStyledText(Object object) {
        Object element = null;
        Object eObject = null;
        StyledString styledString = null;
        if (object instanceof IAdaptable) {
            eObject = (EObject)((IAdaptable)object).getAdapter(EObject.class);
        }
        if ((element = eObject != null ? eObject : object) instanceof Element) {
            styledString = umllabelProvider.getStyledText(element);
        } else {
            styledString = this.provider != null ? (this.provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider ? ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.provider).getStyledText(element) : new StyledString(this.provider.getText(element))) : new StyledString(element.toString());
            this.setDisplayQualifiedNameButton(false);
        }
        return styledString;
    }

    protected void setDisplayQualifiedNameButton(boolean visible) {
        if (this.Toolbar != null && !this.Toolbar.isDisposed() && visible != this.Toolbar.getVisible()) {
            Composite parent = this.Toolbar.getParent();
            this.Toolbar.dispose();
            parent.pack();
        }
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof Element) {
            Object image2 = umllabelProvider.getImage(element);
            if (image2 instanceof Image) {
                image = (Image)image2;
            } else if (image2 instanceof ComposedImage && ((ComposedImage)image2).getImages().get(0) instanceof URL) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)((URL)((ComposedImage)image2).getImages().get(0)));
                image = imageDescriptor.createImage();
            }
        } else if (this.provider != null) {
            image = this.provider.getImage(element);
        }
        return image;
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public void createViewerToolbar(Composite parent) {
        this.Toolbar = new ToolBar(parent, 0);
        ToolItem qualifiedName = new ToolItem(this.Toolbar, 32);
        qualifiedName.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.tools", (String)ICON_QUALIFIED_NAME).createImage());
        qualifiedName.setToolTipText(Messages.FlatTabUMLLabelProvider_QualifyNameButtonTooltip);
        qualifiedName.setSelection(this.displayQualifiedName);
        qualifiedName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean newValue = ((ToolItem)event.getSource()).getSelection();
                if (newValue != FlatTabUMLLabelProvider.this.displayQualifiedName) {
                    FlatTabUMLLabelProvider.this.displayQualifiedName = newValue;
                    FlatTabUMLLabelProvider.this.getDialogSettings().put(FlatTabUMLLabelProvider.DISPLAY_QUALIFIED_NAME_PREF_KEY, FlatTabUMLLabelProvider.this.displayQualifiedName);
                    FlatTabUMLLabelProvider.this.refreshLabelProvider();
                }
            }
        });
        this.refreshLabelProvider();
    }

    protected void refreshLabelProvider() {
        this.types.clear();
        this.stylers.clear();
        this.types.addAll(this.getTypes());
        this.stylers.addAll(this.getStylers());
        if (this.displayQualifiedName) {
            int index = this.types.indexOf(LabelTypesEnum.LABEL.toString());
            if (index > 0) {
                this.types.remove(index);
                this.types.add(index, LabelTypesEnum.QUALIFIED_NAME.toString());
            }
        } else {
            int index = this.types.indexOf(LabelTypesEnum.QUALIFIED_NAME.toString());
            if (index > 0) {
                this.types.remove(index);
                this.types.add(index, LabelTypesEnum.LABEL.toString());
            }
        }
        umllabelProvider.setStylesList(this.types, this.stylers);
        this.notifyChange();
    }

    protected void notifyChange() {
        for (ILabelProviderListener labelProviderListener : this.listeners) {
            labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.provider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.provider = provider;
    }

    protected List<String> getTypes() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, MODELEXPLORER_BUNDLE_NAME);
        String[] types = scopedPreferenceStore.getString(CUSTOMIZED_TYPES_PREF_KEY).split(" ");
        List<String> typesList = Arrays.asList(types);
        return typesList;
    }

    protected List<StyledString.Styler> getStylers() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, MODELEXPLORER_BUNDLE_NAME);
        String[] styles = scopedPreferenceStore.getString(CUSTOMIZED_STYLES_PREF_KEY).split(" ");
        ArrayList<StyledString.Styler> stylesList = new ArrayList<StyledString.Styler>();
        int i = 0;
        while (i < styles.length) {
            stylesList.add(LabelStylersEnum.getByLiteral(styles[i]).getStyler());
            ++i;
        }
        return stylesList;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return settings;
    }
}

