/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class PackageUtil {
    public static final String UML_EXT = "uml";

    public static boolean applyProfile(Package package_, Profile profileToApply, boolean withSubProfiles) {
        EPackage new_definition;
        EPackage previous_definition;
        boolean isChanged = false;
        if (!profileToApply.isDefined()) {
            return isChanged;
        }
        ProfileApplication profileApplication = package_.getProfileApplication(profileToApply);
        if (profileApplication != null && (previous_definition = profileApplication.getAppliedDefinition()) == (new_definition = profileToApply.getDefinition())) {
            return isChanged;
        }
        package_.applyProfile(profileToApply);
        PackageUtil.importTypes(package_, (Package)profileToApply);
        isChanged = true;
        if (withSubProfiles) {
            List<Object> subProfiles = new ArrayList();
            subProfiles = PackageUtil.getSubProfiles((Package)profileToApply);
            for (Profile profile : subProfiles) {
                package_.applyProfile(profile);
                PackageUtil.importTypes(package_, (Package)profile);
            }
        }
        return isChanged;
    }

    public static List<Profile> getSubProfiles(Package package_) {
        ArrayList<Profile> subProfiles = new ArrayList<Profile>();
        for (Object element : package_.getNestedPackages()) {
            if (element instanceof Profile) {
                Profile currentSubProfile = (Profile)element;
                subProfiles.add(currentSubProfile);
                subProfiles.addAll(PackageUtil.getSubProfiles((Package)currentSubProfile));
                continue;
            }
            if (!(element instanceof Package)) continue;
            Package currentSubPackage = (Package)element;
            subProfiles.addAll(PackageUtil.getSubProfiles(currentSubPackage));
        }
        return subProfiles;
    }

    public static Package getRootPackage(Element element) {
        Package nearest = element.getNearestPackage();
        return nearest == null ? null : PackageUtil.getRootPackage(nearest);
    }

    public static Package getRootPackage(Package package_) {
        Element owner = package_.getOwner();
        while (owner != null && !(owner instanceof Package)) {
            owner = owner.getOwner();
        }
        if (owner == null) {
            return package_;
        }
        return PackageUtil.getRootPackage((Package)owner);
    }

    private static void importTypes(Package pkg, Package profileToApply) {
        EList visibleMemb = profileToApply.visibleMembers();
        for (Element elemt : visibleMemb) {
            if (!(elemt instanceof Package) || !((Package)elemt).isModelLibrary()) continue;
            PackageImport pi = UMLFactory.eINSTANCE.createPackageImport();
            pi.setImportedPackage((Package)elemt);
            pkg.getPackageImports().add((Object)pi);
        }
    }

    public static List<String> getImportedPackagesNames(Package pkg) {
        ArrayList<String> packageNames = new ArrayList<String>();
        for (PackageImport currentImport : pkg.getPackageImports()) {
            String currentName = currentImport.getImportedPackage().getName();
            packageNames.add(currentName);
        }
        return packageNames;
    }

    public static void removeLastDefinition(Package thepackage) {
        PackageUtil.removeLastDefinition(thepackage, true);
    }

    public static void removeLastDefinition(Package thepackage, boolean recursive) {
        if (thepackage instanceof Profile) {
            EPackage pak = ((Profile)thepackage).getDefinition();
            ((EAnnotation)pak.eContainer()).getContents().remove((Object)pak);
        }
        if (recursive) {
            for (Package p : thepackage.getNestedPackages()) {
                PackageUtil.removeLastDefinition(p, recursive);
            }
        }
    }

    public static void defineProfiles(Package thePackage) {
        if (thePackage instanceof Profile) {
            ((Profile)thePackage).define();
        }
        for (Package p : thePackage.getNestedPackages()) {
            PackageUtil.defineProfiles(p);
        }
    }

    public static Type findTypeByName(Package pack, String name) {
        assert (name != null) : "Type Name should not be null";
        for (Type t : PackageUtil.getAccessibleTypes(pack)) {
            if (!name.equals(t.getName())) continue;
            return t;
        }
        Resource resource = pack.eResource();
        ResourceSet resourceSet = null;
        if (resource != null) {
            resourceSet = resource.getResourceSet();
        }
        if (resourceSet != null) {
            return PackageUtil.findTypeByName(resourceSet, name);
        }
        return null;
    }

    public static Collaboration findCollaborationByName(Package pack, String name) {
        assert (name != null) : "Collaboration Name should not be null";
        for (Collaboration t : PackageUtil.getAccessibleCollaborations(pack)) {
            if (!name.equals(t.getName())) continue;
            return t;
        }
        Resource resource = pack.eResource();
        ResourceSet resourceSet = null;
        if (resource != null) {
            resourceSet = resource.getResourceSet();
        }
        if (resourceSet != null) {
            return PackageUtil.findCollaborationByName(resourceSet, name);
        }
        return null;
    }

    private static Type findTypeByName(ResourceSet resourceSet, String name) {
        TreeIterator iterator = resourceSet.getAllContents();
        while (iterator.hasNext()) {
            Type type;
            Notifier notifier = (Notifier)iterator.next();
            if (!(notifier instanceof Type) || !name.equals((type = (Type)notifier).getName())) continue;
            return type;
        }
        return null;
    }

    private static Collaboration findCollaborationByName(ResourceSet resourceSet, String name) {
        TreeIterator iterator = resourceSet.getAllContents();
        while (iterator.hasNext()) {
            Collaboration type;
            Notifier notifier = (Notifier)iterator.next();
            if (!(notifier instanceof Collaboration) || !name.equals((type = (Collaboration)notifier).getName())) continue;
            return type;
        }
        return null;
    }

    public static Set<Type> getAllTypes(Element element) {
        TreeSet<Type> set = new TreeSet<Type>(new TypeNameComparator());
        Resource resource = element.eResource();
        ResourceSet resourceSet = null;
        if (resource != null) {
            resourceSet = resource.getResourceSet();
        }
        if (resourceSet != null) {
            TreeIterator iterator = resourceSet.getAllContents();
            while (iterator.hasNext()) {
                Notifier notifier = (Notifier)iterator.next();
                if (!(notifier instanceof Type) || ((Type)notifier).getName() == null) continue;
                set.add((Type)notifier);
            }
        }
        return set;
    }

    public static List<Package> getTopLevelPackages(Element element) {
        BasicEList topLevelPackages = new BasicEList();
        if (element.eResource() != null) {
            for (Resource resource : element.eResource().getResourceSet().getResources()) {
                if (resource.getContents().size() <= 0 || !(resource.getContents().get(0) instanceof Package)) continue;
                topLevelPackages.add((Package)resource.getContents().get(0));
            }
        }
        return topLevelPackages;
    }

    public static Set<Collaboration> getAllCollaborations(Element element) {
        TreeSet<Type> set = new TreeSet<Type>(new TypeNameComparator());
        Resource resource = element.eResource();
        ResourceSet resourceSet = null;
        if (resource != null) {
            resourceSet = resource.getResourceSet();
        }
        if (resourceSet != null) {
            TreeIterator iterator = resourceSet.getAllContents();
            while (iterator.hasNext()) {
                Notifier notifier = (Notifier)iterator.next();
                if (!(notifier instanceof Collaboration) || ((Collaboration)notifier).getName() == null) continue;
                set.add((Type)((Collaboration)notifier));
            }
        }
        return set;
    }

    public static TreeSet<Type> getAccessibleTypes(Package pack) {
        TreeSet<Type> set = new TreeSet<Type>(new TypeNameComparator());
        for (NamedElement element : pack.getMembers()) {
            if (!(element instanceof Type)) continue;
            set.add((Type)element);
        }
        if (pack.getOwner() != null && pack.getOwner() instanceof Package) {
            Iterator<Type> itParent = PackageUtil.getAccessibleTypes(pack.getNestingPackage()).iterator();
            while (itParent.hasNext()) {
                set.add(itParent.next());
            }
        }
        return set;
    }

    public static TreeSet<Collaboration> getAccessibleCollaborations(Package pack) {
        TreeSet<Type> set = new TreeSet<Type>(new TypeNameComparator());
        for (NamedElement element : pack.getMembers()) {
            if (!(element instanceof Collaboration)) continue;
            set.add((Type)((Collaboration)element));
        }
        if (pack.getOwner() != null && pack.getOwner() instanceof Package) {
            Iterator<Collaboration> itParent = PackageUtil.getAccessibleCollaborations(pack.getNestingPackage()).iterator();
            while (itParent.hasNext()) {
                set.add((Type)itParent.next());
            }
        }
        return set;
    }

    public static Set<Element> getAllNestedElements(Package thePackage) {
        HashSet<Element> nestedElements = new HashSet<Element>();
        for (Element currentElement : thePackage.getOwnedMembers()) {
            nestedElements.add(currentElement);
            if (currentElement instanceof Package) {
                nestedElements.addAll(PackageUtil.getAllNestedElements((Package)currentElement));
                continue;
            }
            if (!(currentElement instanceof Class)) continue;
            nestedElements.addAll((Collection<Element>)((Class)currentElement).getMembers());
        }
        return nestedElements;
    }

    public static Package loadPackage(URI uri, ResourceSet set) {
        Package package_ = null;
        Resource resource = set.getResource(uri, true);
        if (resource != null) {
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        } else {
            Activator.logException(new FileNotFoundException("Could not retrieve resource from URI : " + uri + "."));
        }
        return package_;
    }

    public static Package getUserModel(ExecutionEvent event) {
        ServiceUtilsForHandlers serviceUtils = ServiceUtilsForHandlers.getInstance();
        try {
            EObject topEObj;
            URI uri = serviceUtils.getModelSet((Object)event).getURIWithoutExtension().appendFileExtension(UML_EXT);
            Resource userResource = serviceUtils.getModelSet((Object)event).getResource(uri, false);
            if (userResource != null && userResource.getContents().size() > 0 && (topEObj = (EObject)userResource.getContents().get(0)) instanceof Package && !(topEObj instanceof Profile)) {
                return (Package)topEObj;
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    static class TypeNameComparator
    implements Comparator<Type> {
        TypeNameComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            String o1Name = o1.getName() != null ? UMLLabelInternationalization.getInstance().getLabel((NamedElement)o1) : "";
            String o2Name = o2.getName() != null ? UMLLabelInternationalization.getInstance().getLabel((NamedElement)o2) : "";
            return o1Name.compareTo(o2Name);
        }
    }
}

