/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.menuContributor;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.NavigationSubMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuContributor;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.uml.navigation.Activator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildrenButton
implements NavigationMenuContributor {
    public List<NavigationMenuButton> getButtons(Object fromElement) {
        LinkedList<NavigationMenuButton> buttons = new LinkedList<NavigationMenuButton>();
        if (fromElement instanceof Classifier) {
            try {
                NavigationService navigationService = (NavigationService)ServiceUtilsForEObject.getInstance().getService(NavigationService.class, (Object)((Classifier)fromElement));
                LinkedList navigableElements = new LinkedList();
                for (Relationship relationship : ((Element)fromElement).getRelationships()) {
                    Classifier specific;
                    Generalization generalization;
                    if (!(relationship instanceof Generalization) || (generalization = (Generalization)relationship).getGeneral() != fromElement || (specific = generalization.getSpecific()) == null) continue;
                    navigableElements.addAll(navigationService.getNavigableElements((Object)specific));
                }
                if (!navigableElements.isEmpty()) {
                    buttons.add((NavigationMenuButton)new NavigationSubMenuButton("Children...", null, "Show children classes", navigableElements));
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return buttons;
    }
}

