/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.dnd.ui;

import org.eclipse.papyrus.uml.diagram.usecase.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UsecaseOwnerComposite
extends Composite {
    private boolean keepOwner;
    private Button keepOwnerButton;
    private Button switchOwnerButton;

    public UsecaseOwnerComposite(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.keepOwner = true;
        this.createOwnerComposite();
    }

    public UsecaseOwnerComposite(Composite composite, boolean isKeepOwner) {
        super(composite, 0);
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.keepOwner = isKeepOwner;
        this.createOwnerComposite();
    }

    private Composite createOwnerComposite() {
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setText(Messages.UsecaseOwnerComposite_TITLE);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new RowLayout());
        this.keepOwnerButton = new Button(composite, 16);
        this.keepOwnerButton.setText(Messages.UsecaseOwnerComposite_OWNER_KEEP);
        this.keepOwnerButton.setSelection(this.keepOwner);
        this.switchOwnerButton = new Button(composite, 16);
        this.switchOwnerButton.setText(Messages.UsecaseOwnerComposite_OWNER_SWITCH);
        this.switchOwnerButton.setSelection(!this.keepOwner);
        SelectionAdapter selectOwnerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UsecaseOwnerComposite.this.keepOwnerButton.equals(e.getSource())) {
                    UsecaseOwnerComposite.this.keepOwner = true;
                } else {
                    UsecaseOwnerComposite.this.keepOwner = false;
                }
            }
        };
        this.keepOwnerButton.addSelectionListener((SelectionListener)selectOwnerListener);
        this.switchOwnerButton.addSelectionListener((SelectionListener)selectOwnerListener);
        return composite;
    }

    public boolean isKeepOwner() {
        return this.keepOwner;
    }
}

