/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TickEditPart;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public final class TickUtils {
    private static final String OCCURRENCE_TO_TICK_ANNOTATION = "occurrenceToTick";
    private static final String TICK_TO_OCCURRENCE_ANNOTATION = "tickToOccurrence";

    private TickUtils() {
    }

    public static void associateTickNodeToOccurrenceNode(Node tickNode, Node occurrenceNode, boolean overwrite) {
        TickUtils.checkTickView((View)tickNode);
        TickUtils.checkOccurrenceSpecificationView((View)occurrenceNode);
        EAnnotation tickEAnnotation = TickUtils.getOrCreateTickEAnnotation((View)tickNode);
        if (overwrite) {
            TickUtils.clearTickAssociation(tickNode, tickEAnnotation);
        }
        Assert.isLegal((boolean)tickEAnnotation.getReferences().isEmpty(), (String)"A tick can only be associated to one occurrence");
        tickEAnnotation.getReferences().add((Object)occurrenceNode);
        EAnnotation occurrenceEAnnotation = TickUtils.getOrCreateOccurrenceEAnnotation((View)occurrenceNode);
        occurrenceEAnnotation.getReferences().add((Object)tickNode);
    }

    private static void clearTickAssociation(Node tickNode, EAnnotation tickEAnnotation) {
        EList references = tickEAnnotation.getReferences();
        for (EObject eObject : references) {
            EAnnotation occurrenceAnnotation = ((EModelElement)eObject).getEAnnotation(OCCURRENCE_TO_TICK_ANNOTATION);
            if (occurrenceAnnotation == null) continue;
            occurrenceAnnotation.getReferences().remove((Object)tickNode);
        }
        tickEAnnotation.getReferences().clear();
    }

    public static Node getAssociatedOccurrenceView(View tickView) {
        TickUtils.checkTickView(tickView);
        EAnnotation eAnnotation = tickView.getEAnnotation(TICK_TO_OCCURRENCE_ANNOTATION);
        if (eAnnotation != null) {
            EList references = eAnnotation.getReferences();
            if (references.isEmpty()) {
                throw new IllegalStateException("A tick must be associated to one occurrence");
            }
            if (references.size() > 1) {
                throw new IllegalStateException("A tick can be associated to only one occurrence");
            }
            EObject eObject = (EObject)references.get(0);
            if (eObject instanceof Node) {
                Node node = (Node)eObject;
                TickUtils.checkOccurrenceSpecificationView((View)node);
                return node;
            }
            throw new IllegalStateException("A tick must be associated to an occurrence View");
        }
        return null;
    }

    public static List<Node> getAssociatedTickViews(View occurrenceView) {
        ArrayList<Node> result = new ArrayList<Node>();
        TickUtils.checkOccurrenceSpecificationView(occurrenceView);
        EAnnotation eAnnotation = occurrenceView.getEAnnotation(OCCURRENCE_TO_TICK_ANNOTATION);
        if (eAnnotation != null) {
            EList references = eAnnotation.getReferences();
            for (EObject eObject : references) {
                if (eObject instanceof Node) {
                    Node node = (Node)eObject;
                    TickUtils.checkTickView((View)node);
                    result.add(node);
                    continue;
                }
                throw new IllegalStateException("Expecting only tick Nodes");
            }
        }
        return result;
    }

    public static IGraphicalEditPart findOccurrenceSpecificationEditPartFromTickEditPart(TickEditPart tickEditPart, EditPartViewer viewer) {
        IGraphicalEditPart occurrenceSpecificationEditPart;
        Node tickNode;
        Node occurrenceView;
        if (tickEditPart != null && (occurrenceView = TickUtils.getAssociatedOccurrenceView((View)(tickNode = (Node)tickEditPart.getModel()))) != null && (occurrenceSpecificationEditPart = (IGraphicalEditPart)viewer.getEditPartRegistry().get(occurrenceView)) != null) {
            return occurrenceSpecificationEditPart;
        }
        return null;
    }

    public static boolean containsTickFor(View parentView, OccurrenceSpecification occurrenceSpecification) {
        EList children = parentView.getChildren();
        for (View child : children) {
            EObject element;
            TickUtils.checkTickView(child);
            Node occurrenceView = TickUtils.getAssociatedOccurrenceView(child);
            if (occurrenceView == null || (element = occurrenceView.getElement()) != occurrenceSpecification) continue;
            return true;
        }
        return false;
    }

    private static EAnnotation getOrCreateTickEAnnotation(View tickView) {
        TickUtils.checkTickView(tickView);
        EAnnotation eAnnotation = tickView.getEAnnotation(TICK_TO_OCCURRENCE_ANNOTATION);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(TICK_TO_OCCURRENCE_ANNOTATION);
            tickView.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    private static EAnnotation getOrCreateOccurrenceEAnnotation(View occurrenceView) {
        TickUtils.checkOccurrenceSpecificationView(occurrenceView);
        EAnnotation eAnnotation = occurrenceView.getEAnnotation(OCCURRENCE_TO_TICK_ANNOTATION);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(OCCURRENCE_TO_TICK_ANNOTATION);
            occurrenceView.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    private static void checkTickView(View tickView) {
        if (!"Node_TickShape".equals(tickView.getType())) {
            throw new IllegalArgumentException("The parameter must be a tick View (id = Node_TickShape). The id was " + tickView.getType());
        }
    }

    private static void checkOccurrenceSpecificationView(View occurrenceSpecificationView) {
        if (!("OccurrenceSpecification_Shape".equals(occurrenceSpecificationView.getType()) || "MessageOccurrenceSpecification_Shape".equals(occurrenceSpecificationView.getType()) || "DestructionOccurrenceSpecification_Shape".equals(occurrenceSpecificationView.getType()))) {
            throw new IllegalArgumentException("The parameter must be an Occurrencespecification View. The id was " + occurrenceSpecificationView.getType());
        }
    }
}

