/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parts;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.tools.CreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.AddOccurrenceSpecificationInCompactLifelineCommand;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.CutAndInsertOccurrenceSpecificationCommand;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.AbstractTimelineLayoutPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;

public class OccurrenceSpecificationCreationTool
extends CreationTool {
    public OccurrenceSpecificationCreationTool() {
        super(UMLElementTypes.OccurrenceSpecification_Shape);
        this.setDefaultCursor(Cursors.CROSS);
        this.setDisabledCursor(Cursors.NO);
    }

    protected Command getCommand() {
        EditPart timeline;
        EditPart targetEditPart = this.getTargetEditPart();
        CompositeCommand compositeCommand = new CompositeCommand(Messages.OccurrenceSpecificationCreationTool_CreateOccurrenceSpecification);
        if (targetEditPart instanceof FullStateInvariantEditPartCN) {
            FullStateInvariantEditPartCN fullStateInvariantEditPartCN = (FullStateInvariantEditPartCN)targetEditPart;
            timeline = EditPartUtils.findParentEditPartWithId(targetEditPart, "Lifeline_FullSubfragmentCompartment");
            compositeCommand.add((IUndoableOperation)new CutAndInsertOccurrenceSpecificationCommand(fullStateInvariantEditPartCN, this.getLocation(), false));
        } else if (targetEditPart instanceof CompactStateInvariantEditPartCN) {
            CompactStateInvariantEditPartCN compactStateInvariantEditPartCN = (CompactStateInvariantEditPartCN)targetEditPart;
            timeline = EditPartUtils.findParentEditPartWithId(targetEditPart, "Lifeline_CompactSubfragmentCompartment");
            compositeCommand.add((IUndoableOperation)new AddOccurrenceSpecificationInCompactLifelineCommand(compactStateInvariantEditPartCN, this.getLocation()));
        } else {
            return UnexecutableCommand.INSTANCE;
        }
        Command updateLayoutCommand = timeline.getCommand(AbstractTimelineLayoutPolicy.UPDATE_LAYOUT_REQUEST);
        compositeCommand.add((IUndoableOperation)new CommandProxy(updateLayoutCommand));
        return new ICommandProxy((ICommand)compositeCommand);
    }
}

