/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class EllipseDecoration
extends Ellipse
implements RotatableDecoration {
    public EllipseDecoration() {
        this.setPreferredSize(new Dimension(5, 5));
    }

    public void setLocation(Point p) {
        Dimension delta = this.getPreferredSize().getScaled(0.5).getNegated();
        super.setLocation(p.getTranslated(delta));
    }

    public void setReferencePoint(Point p) {
    }

    protected void fillShape(Graphics graphics) {
        Color oldBack = graphics.getBackgroundColor();
        graphics.setBackgroundColor(graphics.getForegroundColor());
        graphics.fillOval(this.getOptimizedBounds());
        graphics.setBackgroundColor(oldBack);
    }

    private Rectangle getOptimizedBounds() {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset = (int)Math.floor(lineInset);
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        r.x += inset;
        r.y += inset;
        return r;
    }

    protected void outlineShape(Graphics graphics) {
    }
}

