/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.locators.CustomEntryExitPointPositionLocator;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;

public class CustomStateLayoutEditPolicy
extends LayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        View childView = (View)child.getModel();
        switch (UMLVisualIDRegistry.getVisualID(childView)) {
            case "ConnectionPointReference_Shape": 
            case "Pseudostate_ExitPointShape": 
            case "Pseudostate_EntryPointShape": {
                return new BorderItemResizableEditPolicy();
            }
        }
        EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
        if (result == null) {
            result = new NonResizableEditPolicy();
        }
        return result;
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewAndElementRequest req;
        if (request instanceof CreateViewAndElementRequest && ((req = (CreateViewAndElementRequest)request).getViewAndElementDescriptor().getSemanticHint().equals(((IHintedType)UMLElementTypes.Pseudostate_EntryPointShape).getSemanticHint()) || req.getViewAndElementDescriptor().getSemanticHint().equals(((IHintedType)UMLElementTypes.Pseudostate_ExitPointShape).getSemanticHint()) || req.getViewAndElementDescriptor().getSemanticHint().equals(((IHintedType)UMLElementTypes.ConnectionPointReference_Shape).getSemanticHint()))) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
            Iterator iter = req.getViewDescriptors().iterator();
            Point parentLoc = this.getHostFigure().getBounds().getLocation().getCopy();
            Point requestedLocation = request.getLocation().getCopy();
            this.getHostFigure().translateToRelative((Translatable)requestedLocation);
            CustomEntryExitPointPositionLocator locator = new CustomEntryExitPointPositionLocator(this.getHostFigure(), 0);
            Rectangle proposedBounds = new Rectangle(requestedLocation, new Dimension(20, 20));
            Rectangle preferredBounds = locator.getPreferredLocation(proposedBounds);
            Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
            while (iter.hasNext()) {
                CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
                cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, creationBounds));
            }
            if (cc.reduce() == null) {
                return null;
            }
            return new ICommandProxy(cc.reduce());
        }
        return null;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }
}

