/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.navigation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.gmfdiag.navigation.CreatedNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.IBaseNameSetter;
import org.eclipse.papyrus.infra.gmfdiag.navigation.IModelLinker;
import org.eclipse.papyrus.infra.gmfdiag.navigation.INavigationRule;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.uml.diagram.navigation.UMLBaseNameSetter;
import org.eclipse.papyrus.uml.diagram.navigation.UMLRuleHelper;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class PackageRule
implements INavigationRule {
    public boolean handle(EObject element) {
        return element instanceof Package;
    }

    public List<NavigableElement> getNextPossibleElements(NavigableElement currentNavElement) {
        LinkedList<NavigableElement> nextPossibleElements = new LinkedList<NavigableElement>();
        EReference packagedFeature = UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT;
        final Package pack = (Package)currentNavElement.getElement();
        for (PackageableElement element : pack.getPackagedElements()) {
            if (!(element instanceof Collaboration)) continue;
            nextPossibleElements.add((NavigableElement)new ExistingNavigableElement((EObject)element, (EStructuralFeature)packagedFeature));
        }
        Collaboration collab = UMLFactory.eINSTANCE.createCollaboration();
        nextPossibleElements.add((NavigableElement)new CreatedNavigableElement((EObject)collab, currentNavElement, (EStructuralFeature)packagedFeature, new IModelLinker(){

            public void linkToModel(EObject toLink) {
                pack.getPackagedElements().add((Object)((PackageableElement)toLink));
            }
        }, (IBaseNameSetter)UMLBaseNameSetter.instance));
        UMLRuleHelper.addBehaviorCreatedNavigableElements(nextPossibleElements, currentNavElement, (EStructuralFeature)UMLPackage.Literals.ELEMENT__OWNED_ELEMENT, new IModelLinker(){

            public void linkToModel(EObject toLink) {
                pack.getPackagedElements().add((Object)((Behavior)toLink));
            }
        });
        return nextPossibleElements;
    }
}

