/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.EdgeWithNoSemanticElementRepresentationImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.StereotypePropertyReferenceEdgeRepresentation;
import org.eclipse.papyrus.uml.diagram.common.dialogs.AbstractCheckedTreeColumnViewerSelectionDialog;
import org.eclipse.papyrus.uml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.diagram.common.util.LinkEndsMapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;

public class ShowHideRelatedLinkSelectionDialog
extends AbstractCheckedTreeColumnViewerSelectionDialog {
    private final int FIRST_COLUMN_WIDTH = 200;
    private final int OTHERS_COLUMN_WIDTH = 100;
    private static final String[] columnsTitles = new String[]{Messages.ShowHideRelatedLinkSelectionDialog_LinksToDisplay, Messages.ShowHideRelatedLinkSelectionDialog_LinkKind, Messages.ShowHideRelatedLinkSelectionDialog_Ends, Messages.ShowHideRelatedLinkSelectionDialog_Sources, Messages.ShowHideRelatedLinkSelectionDialog_Targets};
    private final Map<EObject, LinkEndsMapper> mapLink;
    private ICheckStateProvider checkedStateProvider;
    private ICheckStateListener checkedStateListener;
    private final Map<EditPart, Set<EObject>> availableLinks;
    private final Set<EObject> selectedElements;

    public ShowHideRelatedLinkSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Map<EditPart, Set<EObject>> availableLinks, Map<EObject, LinkEndsMapper> linkEndsMapping) {
        super(parent, labelProvider, contentProvider, 0x1010800, columnsTitles.length);
        this.mapLink = linkEndsMapping;
        this.availableLinks = new HashMap<EditPart, Set<EObject>>(availableLinks);
        this.selectedElements = new HashSet<EObject>();
        this.setContainerMode(true);
        this.init();
    }

    public void setInitialSelection(Collection<EObject> initialSelection) {
        this.selectedElements.addAll(initialSelection);
        super.setInitialSelection(initialSelection.toArray());
    }

    @Override
    protected EditingSupport getEditingSupport(int columnIndex) {
        return null;
    }

    protected void init() {
        this.setColumnTitles(columnsTitles);
        int[] columnWidth = new int[columnsTitles.length];
        columnWidth[0] = 200;
        int i = 1;
        while (i < columnsTitles.length) {
            columnWidth[i] = 100;
            ++i;
        }
        this.setColumnWidths(columnWidth);
        this.setColumnCellLabelProvider(new CellLabelProvider[]{new EObjectLabelProvider(), new LinkEClassLabelProvider(), new EndsElementLabelProvider(), new SourceElementLabelProvider(), new TargetElementLabelProvider()});
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        this.checkedStateProvider = this.getOrCreateCheckStateProvider();
        this.getTreeViewer().setCheckStateProvider(this.checkedStateProvider);
        this.checkedStateListener = this.getOrCreateCheckStateListener();
        this.getTreeViewer().addCheckStateListener(this.checkedStateListener);
        this.updateTree((TreeViewer)this.getTreeViewer());
        return ctrl;
    }

    @Override
    public void create() {
        super.create();
        this.updateTree((TreeViewer)this.getTreeViewer());
    }

    protected ICheckStateListener getOrCreateCheckStateListener() {
        if (this.checkedStateListener == null) {
            this.checkedStateListener = new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Object currentElement = event.getElement();
                    boolean isChecked = event.getChecked();
                    if (currentElement instanceof EditPart) {
                        if (isChecked) {
                            ShowHideRelatedLinkSelectionDialog.this.selectedElements.addAll((Collection)ShowHideRelatedLinkSelectionDialog.this.availableLinks.get(currentElement));
                        } else {
                            ShowHideRelatedLinkSelectionDialog.this.selectedElements.removeAll((Collection)ShowHideRelatedLinkSelectionDialog.this.availableLinks.get(currentElement));
                        }
                        View view = (View)((EditPart)currentElement).getAdapter(View.class);
                        if (view instanceof Edge) {
                            EObject element = view.getElement();
                            for (Set currentCol : ShowHideRelatedLinkSelectionDialog.this.availableLinks.values()) {
                                if (!currentCol.contains(element)) continue;
                                if (isChecked) {
                                    ShowHideRelatedLinkSelectionDialog.this.selectedElements.add(element);
                                    continue;
                                }
                                ShowHideRelatedLinkSelectionDialog.this.selectedElements.remove(element);
                            }
                        }
                    } else if (isChecked) {
                        ShowHideRelatedLinkSelectionDialog.this.selectedElements.add((EObject)currentElement);
                    } else {
                        ShowHideRelatedLinkSelectionDialog.this.selectedElements.remove(currentElement);
                    }
                    ShowHideRelatedLinkSelectionDialog.this.updateTree((TreeViewer)ShowHideRelatedLinkSelectionDialog.this.getTreeViewer());
                }
            };
        }
        return this.checkedStateListener;
    }

    protected final void updateTree(TreeViewer treeViewer) {
        TreeItem[] treeItemArray = this.getTreeViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem items = treeItemArray[n2];
            this.updateTreeItems((TreeViewer)this.getTreeViewer(), items, this.getOrCreateCheckStateProvider());
            ++n2;
        }
    }

    private void updateTreeItems(TreeViewer treeViewer, TreeItem item, ICheckStateProvider stateProvider) {
        boolean isChecked = stateProvider.isChecked(item.getData());
        boolean isGrayed = stateProvider.isGrayed(item.getData());
        item.setChecked(isChecked);
        item.setGrayed(isGrayed);
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.updateTreeItems(treeViewer, child, stateProvider);
            ++n2;
        }
    }

    protected ICheckStateProvider getOrCreateCheckStateProvider() {
        if (this.checkedStateProvider == null) {
            this.checkedStateProvider = new ICheckStateProvider(){

                public boolean isGrayed(Object element) {
                    boolean isGrayed = false;
                    if (element instanceof EditPart) {
                        Set values = (Set)ShowHideRelatedLinkSelectionDialog.this.availableLinks.get(element);
                        ArrayList tmp = new ArrayList(ShowHideRelatedLinkSelectionDialog.this.selectedElements);
                        tmp.retainAll(values);
                        isGrayed = tmp.size() != values.size();
                    }
                    return isGrayed;
                }

                public boolean isChecked(Object element) {
                    boolean isChecked = false;
                    if (element instanceof EditPart) {
                        Collection possibleLinks = (Collection)ShowHideRelatedLinkSelectionDialog.this.availableLinks.get(element);
                        ArrayList tmp = new ArrayList(ShowHideRelatedLinkSelectionDialog.this.selectedElements);
                        tmp.retainAll(possibleLinks);
                        isChecked = tmp.size() > 0;
                        View view = (View)((EditPart)element).getAdapter(View.class);
                        if (!isChecked && view instanceof Edge) {
                            EObject eobject = view.getElement();
                            isChecked = ShowHideRelatedLinkSelectionDialog.this.selectedElements.contains(eobject);
                        }
                    } else if (element instanceof EObject) {
                        isChecked = ShowHideRelatedLinkSelectionDialog.this.selectedElements.contains(element);
                    }
                    return isChecked;
                }
            };
        }
        return this.checkedStateProvider;
    }

    public abstract class AbstractLinkEndColumnsLabelProvider
    extends ColumnLabelProvider {
        public static final String START_LIST = "[";
        public static final String END_LIST = "]";
        public static final String VALUE_SEPARATOR = ",";
        private final ILabelProvider labelProvider;

        public AbstractLinkEndColumnsLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Image getImage(Object element) {
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            cell.setText(this.getText(cell.getElement()));
        }

        public String getText(Object element) {
            StringBuilder builder = new StringBuilder();
            Collection<?> ends = this.getValues(element);
            if (!ends.isEmpty()) {
                builder.append(START_LIST);
                Iterator<?> iter = ends.iterator();
                while (iter.hasNext()) {
                    Object current = iter.next();
                    if (current instanceof Comment) {
                        builder.append(Messages.ShowHideRelatedLinkSelectionDialog_Comment_);
                    }
                    builder.append(this.labelProvider.getText(current));
                    if (!iter.hasNext()) continue;
                    builder.append(VALUE_SEPARATOR);
                }
                builder.append(END_LIST);
            }
            return builder.toString();
        }

        protected abstract Collection<?> getValues(Object var1);
    }

    protected class EObjectLabelProvider
    extends ColumnLabelProvider {
        private final ILabelProvider labelProvider;

        public EObjectLabelProvider() {
            this.labelProvider = ShowHideRelatedLinkSelectionDialog.this.getLabelProvider();
        }

        public Image getImage(Object element) {
            EObject source;
            if (element instanceof EdgeWithNoSemanticElementRepresentationImpl && ((source = ((EdgeWithNoSemanticElementRepresentationImpl)element).getSource()) instanceof Comment || source instanceof Constraint)) {
                return this.labelProvider.getImage((Object)source);
            }
            return this.labelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof EdgeWithNoSemanticElementRepresentationImpl) {
                EObject source = ((EdgeWithNoSemanticElementRepresentationImpl)element).getSource();
                if (source instanceof Comment) {
                    return Messages.ShowHideRelatedLinkSelectionDialog_CommentLink;
                }
                if (source instanceof Constraint) {
                    return Messages.ShowHideRelatedLinkSelectionDialog_ConstraintLink;
                }
                if (element instanceof StereotypePropertyReferenceEdgeRepresentation) {
                    return String.valueOf(((StereotypePropertyReferenceEdgeRepresentation)element).getStereotypeQualifiedName()) + "::" + ((StereotypePropertyReferenceEdgeRepresentation)element).getFeatureToSet();
                }
            }
            return this.labelProvider.getText(element);
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            cell.setText(this.getText(cell.getElement()));
        }
    }

    protected class EndsElementLabelProvider
    extends AbstractLinkEndColumnsLabelProvider {
        public EndsElementLabelProvider(ILabelProvider labelProvider) {
            super(labelProvider);
        }

        public EndsElementLabelProvider() {
            super(ShowHideRelatedLinkSelectionDialog.this.getLabelProvider());
        }

        @Override
        protected Collection<?> getValues(Object element) {
            LinkEndsMapper mapper = (LinkEndsMapper)ShowHideRelatedLinkSelectionDialog.this.mapLink.get(element);
            if (mapper != null) {
                return mapper.getEnds();
            }
            return Collections.emptyList();
        }
    }

    protected class LinkEClassLabelProvider
    extends ColumnLabelProvider {
        private final ILabelProvider labelProvider;

        public LinkEClassLabelProvider() {
            this.labelProvider = ShowHideRelatedLinkSelectionDialog.this.getLabelProvider();
        }

        public Image getImage(Object element) {
            if (element instanceof EdgeWithNoSemanticElementRepresentationImpl) {
                return null;
            }
            if (element instanceof EObject) {
                return this.labelProvider.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof EdgeWithNoSemanticElementRepresentationImpl) {
                EObject source = ((EdgeWithNoSemanticElementRepresentationImpl)element).getSource();
                if (source instanceof Comment) {
                    return Messages.ShowHideRelatedLinkSelectionDialog_CommentLink;
                }
                if (source instanceof Constraint) {
                    return Messages.ShowHideRelatedLinkSelectionDialog_ConstraintLink;
                }
                if (element instanceof StereotypePropertyReferenceEdgeRepresentation) {
                    return Messages.ShowHideRelatedLinkSelectionDialog_StereotypePropertyReferenceLabel;
                }
            }
            if (element instanceof EObject) {
                return ((EObject)element).eClass().getName();
            }
            return "";
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            cell.setText(this.getText(cell.getElement()));
        }
    }

    protected class SourceElementLabelProvider
    extends AbstractLinkEndColumnsLabelProvider {
        public SourceElementLabelProvider(ILabelProvider labelProvider) {
            super(labelProvider);
        }

        public SourceElementLabelProvider() {
            super(ShowHideRelatedLinkSelectionDialog.this.getLabelProvider());
        }

        @Override
        protected Collection<?> getValues(Object element) {
            LinkEndsMapper mapper = (LinkEndsMapper)ShowHideRelatedLinkSelectionDialog.this.mapLink.get(element);
            if (mapper != null) {
                return mapper.getSources();
            }
            return Collections.emptyList();
        }
    }

    protected class TargetElementLabelProvider
    extends AbstractLinkEndColumnsLabelProvider {
        public TargetElementLabelProvider(ILabelProvider labelProvider) {
            super(labelProvider);
        }

        public TargetElementLabelProvider() {
            super(ShowHideRelatedLinkSelectionDialog.this.getLabelProvider());
        }

        @Override
        protected Collection<?> getValues(Object element) {
            LinkEndsMapper mapper = (LinkEndsMapper)ShowHideRelatedLinkSelectionDialog.this.mapLink.get(element);
            if (mapper != null) {
                return mapper.getTargets();
            }
            return Collections.emptyList();
        }
    }
}

