/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.strategy.paste;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.uml.diagram.common.strategy.paste.ShowConstraintContextLink;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;

public class ConstraintPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new ConstraintPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "ConstraintStrategy";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.common.ConstraintStrategy";
    }

    public String getDescription() {
        return "Paste constraint elements and context links";
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        if (targetOwner instanceof Element) {
            org.eclipse.emf.common.command.CompoundCommand compoundCommand = new org.eclipse.emf.common.command.CompoundCommand("Reassociate constraint context");
            Map additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
            for (Object object : papyrusClipboard) {
                ConstraintClipboard constraintClipboard;
                Namespace context;
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (target == null || !(target instanceof Constraint) || !this.checkContext(targetOwner, context = (constraintClipboard = (ConstraintClipboard)additionalDataMap.get(object)).getContext())) continue;
                RecordingCommand buildSemanticCommand = this.buildSemanticCommand(domain, (Constraint)target, context);
                compoundCommand.append((Command)buildSemanticCommand);
            }
            if (compoundCommand.getCommandList().isEmpty()) {
                return null;
            }
            return compoundCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public org.eclipse.gef.commands.Command getGraphicalCommand(EditingDomain domain, GraphicalEditPart targetEditPart, PapyrusClipboard<Object> papyrusClipboard) {
        HashSet<Constraint> alreadyprocesed = new HashSet<Constraint>();
        View targetView = (View)targetEditPart.getModel();
        EObject targetOwner = targetView.getElement();
        CompoundCommand compoundCommand = new CompoundCommand("Reassociate constraint context");
        Map additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
        if (targetEditPart.resolveSemanticElement() instanceof Class) {
            return null;
        }
        for (Object object : papyrusClipboard) {
            RecordingCommand semanticCommand;
            Namespace context;
            Constraint targetConstraint;
            EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
            if (!(target instanceof View) || !(((View)target).getElement() instanceof Constraint) || alreadyprocesed.contains(targetConstraint = (Constraint)((View)target).getElement())) continue;
            if (targetConstraint.getContext() != null) {
                ShowConstraintContextLink command = new ShowConstraintContextLink((TransactionalEditingDomain)domain, targetEditPart, (View)target);
                compoundCommand.add(GMFtoGEFCommandWrapper.wrap((ICommand)command));
                alreadyprocesed.add(targetConstraint);
                continue;
            }
            Object internalFromTarget = this.getInternalFromTarget(papyrusClipboard, (EObject)targetConstraint);
            ConstraintClipboard constraintClipboard = (ConstraintClipboard)additionalDataMap.get(internalFromTarget);
            if (constraintClipboard == null || !this.checkContext(targetOwner, context = constraintClipboard.getContext()) || (semanticCommand = this.buildSemanticCommand(domain, targetConstraint, context)) == null) continue;
            compoundCommand.add(EMFtoGEFCommandWrapper.wrap((Command)semanticCommand));
            ShowConstraintContextLink command = new ShowConstraintContextLink((TransactionalEditingDomain)domain, targetEditPart, (View)target);
            compoundCommand.add(GMFtoGEFCommandWrapper.wrap((ICommand)command));
            alreadyprocesed.add(targetConstraint);
        }
        if (compoundCommand.getChildren().length == 0) {
            return null;
        }
        return compoundCommand;
    }

    protected RecordingCommand buildSemanticCommand(EditingDomain domain, final Constraint targetConstraint, final Namespace context) {
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)domain, "Set Context for constraint"){

            protected void doExecute() {
                targetConstraint.setContext(context);
            }
        };
        return command;
    }

    protected boolean checkContext(EObject targetOwner, Namespace context) {
        boolean contains = false;
        if (targetOwner instanceof Namespace) {
            Namespace targetNamespace = (Namespace)targetOwner;
            contains = targetNamespace.getMembers().contains((Object)context);
        }
        return contains;
    }

    protected Object getInternalFromTarget(PapyrusClipboard<Object> papyrusClipboard, EObject target) {
        Map internalClipboardToTargetCopy = papyrusClipboard.getInternalClipboardToTargetCopy();
        Set entrySet = internalClipboardToTargetCopy.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((EObject)entry.getValue()).equals(target)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, ConstraintClipboard> mapCopyToConstraintData = new HashMap<Object, ConstraintClipboard>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            EObject eObjectSource = (EObject)iterator.next();
            if (!(eObjectSource instanceof Constraint)) continue;
            Constraint constraint = (Constraint)eObjectSource;
            ConstraintClipboard constraintClipboard = new ConstraintClipboard(constraint);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToConstraintData.put(copy, constraintClipboard);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToConstraintData);
    }

    protected class ConstraintClipboard
    implements IClipboardAdditionalData {
        private Namespace context;

        public ConstraintClipboard(Constraint constraint) {
            this.context = constraint.getContext();
        }

        public Namespace getContext() {
            return this.context;
        }
    }
}

