/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.IStereotypeViewFactory;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateStereotypeLabelCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeViewFactory
implements IStereotypeViewFactory {
    private View mainView;
    private TransactionalEditingDomain domain;

    public StereotypeViewFactory(View mainView) {
        this.mainView = mainView;
        this.domain = CommandUtil.resolveEditingDomain(mainView);
    }

    @Override
    public void createPropertyView(Property property, Stereotype stereotype, View owner, String location) {
        if ("Compartment".equals(location)) {
            this.createStereotypePropertyInCompartment(owner, property);
        } else if ("With brace".equals(location)) {
            this.createStereotypePropertyInBrace(owner, property);
        } else if ("Comment".equals(location)) {
            this.createStereotypePropertyInComment(owner, property);
        }
    }

    @Override
    public void createCompartmentView(Stereotype stereotype, String location) {
        if ("Compartment".equals(location)) {
            this.createStereotypeCompartmentInCompartment(stereotype);
        } else if ("With brace".equals(location)) {
            this.createStereotypeCompartmentInBrace(stereotype);
        } else if ("Comment".equals(location)) {
            this.createStereotypeCompartmentInComment(stereotype);
        }
    }

    @Override
    public void createLabelView(Stereotype stereotype) {
        this.createStereotypeLabel(stereotype);
    }

    private void createStereotypeCompartmentInComment(Stereotype stereotype) {
        Node comment = StereotypeDisplayUtil.getInstance().getStereotypeComment(this.mainView);
        CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(this.domain, (View)comment, stereotype, "StereotypeCompartment");
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }

    private void createStereotypeCompartmentInBrace(Stereotype stereotype) {
        CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(this.domain, this.mainView, stereotype, "StereotypeBrace");
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }

    private void createStereotypeCompartmentInCompartment(Stereotype stereotype) {
        CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(this.domain, this.mainView, stereotype, "StereotypeCompartment");
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }

    private void createStereotypePropertyInCompartment(View compartment, Property property) {
        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(this.domain, compartment, property, "StereotypeProperty");
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }

    private void createStereotypePropertyInBrace(View compartmentView, Property property) {
        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(this.domain, this.mainView, property, "StereotypeBrace");
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }

    private void createStereotypePropertyInComment(View compartmentView, Property property) {
        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(this.domain, compartmentView, property, "StereotypeProperty");
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }

    private void createStereotypeLabel(Stereotype stereotype) {
        CreateStereotypeLabelCommand command = new CreateStereotypeLabelCommand(this.domain, this.mainView, stereotype);
        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.mainView);
    }
}

