/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.sheet;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.UnsetObject;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.uml2.uml.Stereotype;

public class UMLPropertySource
extends PropertySource {
    public UMLPropertySource(Object object, IItemPropertySource ips) {
        super(object, ips);
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new CustomPropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    private class CustomPropertyDescriptor
    extends PropertyDescriptor {
        public CustomPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        public CellEditor createPropertyEditor(Composite composite) {
            if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                return null;
            }
            ExtendedDialogCellEditor result = null;
            final Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
            if (!(genericFeature instanceof EReference)) {
                return super.createPropertyEditor(composite);
            }
            if (!((EReference)genericFeature).isMany()) {
                final Object initialSelection = ((EObject)this.object).eGet((EStructuralFeature)genericFeature);
                ILabelProvider editLabelProvider = this.getEditLabelProvider();
                result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        CustomUMLContentProvider provider = new CustomUMLContentProvider((EObject)CustomPropertyDescriptor.this.object, (EStructuralFeature)genericFeature);
                        provider.addTemporaryElement(UnsetObject.instance);
                        TreeSelectorDialog dialog = new TreeSelectorDialog(cellEditorWindow.getShell());
                        dialog.setTitle(Messages.UMLPropertySource_ElementSelection);
                        dialog.setContentProvider((ITreeContentProvider)provider);
                        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                        Object[] selectedValue = new Object[]{initialSelection};
                        dialog.setInitialSelections(selectedValue);
                        int userResponse = dialog.open();
                        Object toReturn = null;
                        if (userResponse == 0) {
                            toReturn = dialog.getResult()[0];
                            if (toReturn == null) {
                                toReturn = CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(null);
                            }
                        } else {
                            toReturn = CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(CustomPropertyDescriptor.this.object);
                        }
                        return toReturn;
                    }
                };
            } else {
                ILabelProvider editLabelProvider = this.getEditLabelProvider();
                result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        Object initialSelection = ((EObject)CustomPropertyDescriptor.this.object).eGet((EStructuralFeature)genericFeature);
                        UMLContentProvider provider = new UMLContentProvider((EObject)CustomPropertyDescriptor.this.object, (EStructuralFeature)genericFeature);
                        ReferenceSelector referenceSelector = new ReferenceSelector(true);
                        referenceSelector.setContentProvider((IStaticContentProvider)provider);
                        referenceSelector.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                        MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(cellEditorWindow.getShell(), (IElementSelector)referenceSelector);
                        dialog.setInitialElementSelections((List)initialSelection);
                        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                        dialog.setContextElement(CustomPropertyDescriptor.this.object);
                        dialog.setTitle(Messages.UMLPropertySource_ElementSelection);
                        Object toReturn = null;
                        toReturn = dialog.open() == 0 ? Arrays.asList(dialog.getResult()) : CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(CustomPropertyDescriptor.this.object);
                        return toReturn;
                    }
                };
            }
            return result;
        }
    }

    public class CustomUMLContentProvider
    extends UMLContentProvider {
        public CustomUMLContentProvider() {
        }

        public CustomUMLContentProvider(EObject source, EStructuralFeature feature, Stereotype stereotype, ResourceSet root) {
            super(source, feature, stereotype, root);
        }

        public CustomUMLContentProvider(EObject source, EStructuralFeature feature, Stereotype stereotype) {
            super(source, feature, stereotype);
        }

        public CustomUMLContentProvider(EObject source, EStructuralFeature feature) {
            super(source, feature);
        }

        public boolean isValidValue(Object element) {
            boolean result = false;
            if (element != null) {
                result = element.equals(UnsetObject.instance);
                if (this.feature instanceof ENamedElement && this.feature.getName().equals("classifierBehavior") && element instanceof EObjectTreeElement) {
                    return this.isOwned(UMLPropertySource.this.object, ((EObjectTreeElement)element).getEObject());
                }
            }
            return super.isValidValue(element) || result;
        }

        public boolean isOwned(Object parent, EObject child) {
            child = child.eContainer();
            while (child != null) {
                if (child == parent) {
                    return true;
                }
                child = child.eContainer();
            }
            return false;
        }
    }
}

