/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeInterval;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintParser
implements IParser,
ISemanticParser {
    protected static final String OPAQUE_EXPRESSION_BEGIN_LANGUAGE = "{";
    protected static final String OPAQUE_EXPRESSION_END_LANGUAGE = "} ";

    public String getEditString(IAdaptable element, int flags) {
        Constraint constraint = this.doAdapt(element);
        if (constraint == null || constraint.getSpecification() == null) {
            return "<NULL Constraint>";
        }
        if (constraint.getSpecification() instanceof LiteralString) {
            return ((LiteralString)constraint.getSpecification()).getValue();
        }
        if (constraint.getSpecification() instanceof DurationInterval) {
            if (((DurationInterval)constraint.getSpecification()).getMin() != null && ((DurationInterval)constraint.getSpecification()).getMax() != null) {
                return String.valueOf(((DurationInterval)constraint.getSpecification()).getMin().stringValue()) + ".." + ((DurationInterval)constraint.getSpecification()).getMax().stringValue();
            }
            return "0..0";
        }
        if (constraint.getSpecification() instanceof TimeInterval) {
            if (((TimeInterval)constraint.getSpecification()).getMin() != null && ((TimeInterval)constraint.getSpecification()).getMax() != null) {
                return String.valueOf(((TimeInterval)constraint.getSpecification()).getMin().stringValue()) + ".." + ((TimeInterval)constraint.getSpecification()).getMax().stringValue();
            }
            return "0..0";
        }
        if (constraint.getSpecification() instanceof Interval) {
            if (((Interval)constraint.getSpecification()).getMin() != null && ((Interval)constraint.getSpecification()).getMax() != null) {
                return String.valueOf(((Interval)constraint.getSpecification()).getMin().stringValue()) + ".." + ((Interval)constraint.getSpecification()).getMax().stringValue();
            }
            return "0..0";
        }
        if (constraint.getSpecification() instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)constraint.getSpecification();
            if (opaqueExpression.getBodies().size() > 0) {
                StringBuilder b = new StringBuilder();
                if (opaqueExpression.getLanguages().size() > 0) {
                    b.append(OPAQUE_EXPRESSION_BEGIN_LANGUAGE);
                    b.append((String)opaqueExpression.getLanguages().get(0));
                    b.append(OPAQUE_EXPRESSION_END_LANGUAGE);
                }
                b.append((String)opaqueExpression.getBodies().get(0));
                return b.toString();
            }
            return "{NATURAL} ";
        }
        return "";
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        LiteralString specif;
        Constraint constraint = this.doAdapt(element);
        if (constraint == null || constraint.getSpecification() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)constraint);
        if (editingDomain == null || constraint.getSpecification() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        if (constraint.getSpecification() instanceof LiteralString) {
            specif = (LiteralString)constraint.getSpecification();
            command = new CompositeTransactionalCommand(editingDomain, "Set Value Constraint");
            SetRequest request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralString_Value(), (Object)newString);
            command.compose((IUndoableOperation)new SetValueCommand(request));
        }
        if (constraint.getSpecification() instanceof OpaqueExpression) {
            specif = (OpaqueExpression)constraint.getSpecification();
            command = new CompositeTransactionalCommand(editingDomain, "Set Value Constraint");
            ArrayList<String> stringBodyList = new ArrayList<String>();
            ArrayList<String> stringLanguageList = new ArrayList<String>();
            stringLanguageList.add(newString.substring(1, newString.indexOf(OPAQUE_EXPRESSION_END_LANGUAGE)).toUpperCase());
            stringBodyList.add(newString.substring(newString.indexOf(OPAQUE_EXPRESSION_END_LANGUAGE) + 2, newString.length()));
            SetRequest request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Body(), stringBodyList);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Language(), stringLanguageList);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            return command;
        }
        if (constraint.getSpecification() instanceof DurationInterval) {
            specif = (Interval)constraint.getSpecification();
            command = new CompositeTransactionalCommand(editingDomain, "Set Value Constraint");
            Duration durationMin = UMLFactory.eINSTANCE.createDuration();
            durationMin.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)durationMin.eClass().getName(), (Collection)constraint.eContents()));
            Duration durationMax = UMLFactory.eINSTANCE.createDuration();
            durationMax.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)durationMax.eClass().getName(), (Collection)constraint.eContents()));
            LiteralString exp1 = UMLFactory.eINSTANCE.createLiteralString();
            LiteralString exp2 = UMLFactory.eINSTANCE.createLiteralString();
            exp1.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)exp1.eClass().getName(), (Collection)durationMin.eContents()));
            exp1.setValue(newString.substring(0, newString.indexOf("..")));
            exp2.setValue(newString.substring(newString.indexOf("..") + 2, newString.length()));
            exp2.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)exp2.eClass().getName(), (Collection)durationMax.eContents()));
            durationMin.setExpr((ValueSpecification)exp1);
            durationMax.setExpr((ValueSpecification)exp2);
            SetRequest request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getInterval_Min(), (Object)durationMin);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getInterval_Max(), (Object)durationMax);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            return command;
        }
        if (constraint.getSpecification() instanceof TimeInterval) {
            specif = (TimeInterval)constraint.getSpecification();
            command = new CompositeTransactionalCommand(editingDomain, "Set Value Constraint");
            TimeExpression timeMin = UMLFactory.eINSTANCE.createTimeExpression();
            timeMin.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)timeMin.eClass().getName(), (Collection)constraint.eContents()));
            TimeExpression timeMax = UMLFactory.eINSTANCE.createTimeExpression();
            timeMax.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)timeMax.eClass().getName(), (Collection)constraint.eContents()));
            LiteralString exp1 = UMLFactory.eINSTANCE.createLiteralString();
            LiteralString exp2 = UMLFactory.eINSTANCE.createLiteralString();
            exp1.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)exp1.eClass().getName(), (Collection)timeMin.eContents()));
            exp1.setValue(newString.substring(0, newString.indexOf("..")));
            exp2.setValue(newString.substring(newString.indexOf("..") + 2, newString.length()));
            exp2.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)exp2.eClass().getName(), (Collection)timeMax.eContents()));
            timeMin.setExpr((ValueSpecification)exp1);
            timeMax.setExpr((ValueSpecification)exp2);
            SetRequest request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getInterval_Min(), (Object)timeMin);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getInterval_Max(), (Object)timeMax);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            return command;
        }
        if (constraint.getSpecification() instanceof Interval) {
            specif = (Interval)constraint.getSpecification();
            command = new CompositeTransactionalCommand(editingDomain, "Set Value Constraint");
            LiteralInteger min = UMLFactory.eINSTANCE.createLiteralInteger();
            LiteralInteger max = UMLFactory.eINSTANCE.createLiteralInteger();
            min.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)min.eClass().getName(), (Collection)min.eContents()));
            max.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)max.eClass().getName(), (Collection)max.eContents()));
            Integer minInt = new Integer(newString.substring(0, newString.indexOf("..")));
            Integer maxInt = new Integer(newString.substring(newString.indexOf("..") + 2, newString.length()));
            min.setValue(minInt.intValue());
            max.setValue(maxInt.intValue());
            SetRequest request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getInterval_Min(), (Object)min);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            request = new SetRequest((EObject)specif, (EStructuralFeature)UMLPackage.eINSTANCE.getInterval_Max(), (Object)max);
            command.compose((IUndoableOperation)new SetValueCommand(request));
            return command;
        }
        return command;
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    protected Constraint doAdapt(IAdaptable element) {
        EObject obj = EMFHelper.getEObject((Object)element);
        if (obj instanceof Constraint) {
            return (Constraint)obj;
        }
        return null;
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        Constraint constraint;
        Element umlElement = (Element)element;
        LinkedList<ValueSpecification> result = new LinkedList<ValueSpecification>();
        if (umlElement instanceof Constraint && (constraint = (Constraint)umlElement).getSpecification() != null) {
            ValueSpecification value = constraint.getSpecification();
            result.add(value);
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }
}

