/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ScaledImageFigure
extends ImageFigure {
    private double scale = 1.0;
    private Dimension size;

    protected void paintFigure(Graphics graphics) {
        Image img = this.getImage();
        if (img == null) {
            return;
        }
        Rectangle area = this.getBounds().getShrinked(this.getInsets());
        int x = (area.width - (int)((double)this.size.width * this.scale)) / 2 + area.x;
        int y = (area.height - (int)((double)this.size.height * this.scale)) / 2 + area.y;
        graphics.drawImage(this.getImage(), 0, 0, this.size.width, this.size.height, x, y, (int)((double)this.size.width * this.scale), (int)((double)this.size.height * this.scale));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint).getCopy();
        d.scale(this.scale);
        return d;
    }

    public void setImage(Image image) {
        this.size = image != null ? new Rectangle(image.getBounds()).getSize() : new Dimension();
        super.setImage(image);
    }

    public void setScale(double scale) {
        if (scale < 1.0 && scale > 0.0) {
            this.scale = scale;
        }
    }
}

