/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideCompartmentRequest;

public class ShowHideCompartmentEditPolicy
extends AbstractEditPolicy {
    public static final String SHOW_HIDE_COMPARTMENT_POLICY = "Show/Hide Compartment Policy";
    List<View> childlistened = new ArrayList<View>();
    private NotificationListener listener = new NotificationListener(){

        public void notifyChanged(Notification notification) {
            ShowHideCompartmentEditPolicy.this.getHost().refresh();
        }
    };

    public Command getCommand(Request request) {
        if (request.getType().equals("Show/Hide Compartment")) {
            ShowHideCompartmentRequest req = (ShowHideCompartmentRequest)request;
            return this.getShowHideCompartmentCommand(req);
        }
        return null;
    }

    protected Command getShowHideCompartmentCommand(ShowHideCompartmentRequest request) {
        if (this.getHost() instanceof TopGraphicEditPart) {
            List<?> views = this.getAllNotationViews((TopGraphicEditPart)this.getHost());
            for (View childView : views) {
                if (!ViewUtil.isPropertySupported((View)childView, (Object)request.getPropertyID()) || !childView.equals(request.getCompartment())) continue;
                DiagramEventBroker diagramEventBroker = this.getDiagramEventBroker();
                if (request.getValue() instanceof Boolean && diagramEventBroker != null) {
                    if (((Boolean)request.getValue()).booleanValue()) {
                        diagramEventBroker.addNotificationListener((EObject)childView, this.listener);
                        this.childlistened.add(childView);
                    } else {
                        diagramEventBroker.removeNotificationListener((EObject)childView, this.listener);
                        this.childlistened.remove(childView);
                    }
                }
                return new ICommandProxy((ICommand)new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)childView), request.getPropertyID(), request.getPropertyName(), request.getValue()));
            }
        }
        return null;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        DiagramEventBroker eventBroker = null;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (editingDomain != null) {
            eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain);
        }
        return eventBroker;
    }

    public void deactivate() {
        DiagramEventBroker diagramEventBroker = this.getDiagramEventBroker();
        if (diagramEventBroker != null) {
            for (View child : this.childlistened) {
                diagramEventBroker.removeNotificationListener((EObject)child, this.listener);
            }
        }
        super.deactivate();
    }

    public List<?> getAllNotationViews(TopGraphicEditPart ep) {
        View view = ep.getNotationView();
        if (view != null) {
            ArrayList<View> views = new ArrayList<View>();
            for (View child : view.getChildren()) {
                if (!(child instanceof Node)) continue;
                views.add(child);
            }
            return views;
        }
        return Collections.EMPTY_LIST;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }
}

