/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.listenerservice.ModelListenerManager;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.model.DecoratorModel;
import org.eclipse.papyrus.uml.tools.model.UmlModel;

public class UMLSnippet
implements IModelSnippet {
    private DecoratorModel model;
    private Adapter resourceAdapter;
    private ModelListenerManager modelListenerManager;

    public void start(IModel startingModel) {
        this.model = (DecoratorModel)startingModel;
        ModelSet modelSet = this.model.getModelManager();
        UmlModel uml = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (uml != null) {
            this.modelListenerManager = this.getModelListenerManager(uml);
            if (this.modelListenerManager != null) {
                modelSet.eAdapters().add((Object)this.getResourceAdapter());
            }
        }
    }

    public void dispose(IModel stoppingModel) {
        if (stoppingModel == this.model) {
            if (this.modelListenerManager != null) {
                ModelSet modelSet = ((DecoratorModel)stoppingModel).getModelManager();
                modelSet.eAdapters().remove((Object)this.getResourceAdapter());
            }
            this.resourceAdapter = null;
            this.modelListenerManager = null;
            this.model = null;
        }
    }

    private ModelListenerManager getModelListenerManager(UmlModel uml) {
        ModelListenerManager result = null;
        Resource resource = uml.getResource();
        if (resource != null) {
            result = (ModelListenerManager)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resource.eAdapters(), ModelListenerManager.class), null);
        }
        return result;
    }

    private Adapter getResourceAdapter() {
        if (this.resourceAdapter == null) {
            this.resourceAdapter = new ResourceAdapter(){
                private Set<Resource> managedResources = Sets.newHashSet();

                protected void handleResourceAdded(Resource resource) {
                    if (UMLSnippet.this.model.isDecoratorModelResource(resource) || DecoratorModelUtils.isDecoratorModel(resource.getURI())) {
                        this.managedResources.add(resource);
                        resource.eAdapters().add((Object)UMLSnippet.this.modelListenerManager);
                    }
                }

                protected void handleResourceRemoved(Resource resource) {
                    if (this.managedResources.remove(resource)) {
                        resource.eAdapters().remove((Object)UMLSnippet.this.modelListenerManager);
                    }
                }

                public void unsetTarget(Notifier oldTarget) {
                    super.unsetTarget(oldTarget);
                    if (this.managedResources.remove(oldTarget)) {
                        oldTarget.eAdapters().remove((Object)UMLSnippet.this.modelListenerManager);
                    }
                }
            };
        }
        return this.resourceAdapter;
    }
}

