/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.alf.ElementReference;
import org.eclipse.papyrus.uml.alf.NamespaceDefinition;
import org.eclipse.papyrus.uml.alf.QualifiedName;
import org.eclipse.papyrus.uml.alf.SyntaxElement;
import org.eclipse.papyrus.uml.alf.impl.ModelNamespaceImpl;
import org.eclipse.papyrus.uml.alf.validation.AlfValidationContextRegistry;
import org.eclipse.uml2.uml.Namespace;

public class ModelNamespaceFacade {
    private static ModelNamespaceFacade INSTANCE;
    protected AlfValidationContextRegistry registry = new AlfValidationContextRegistry();

    private ModelNamespaceFacade() {
    }

    public static ModelNamespaceFacade getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelNamespaceFacade();
        }
        return INSTANCE;
    }

    public ModelNamespaceImpl getContext(SyntaxElement element) {
        if (element.eResource() == null) {
            return this.registry.getCurrentlyUsedValidationContext();
        }
        ModelNamespaceImpl namespace = this.registry.getValidationContext(element.eResource().getURI());
        if (namespace == null) {
            namespace = this.registry.createEmptyValidationContext(element.eResource().getURI());
        }
        return namespace;
    }

    public NamespaceDefinition modelNamespaceFor(NamespaceDefinition namespace) {
        ModelNamespaceImpl modelNamespace = this.getContext(namespace);
        modelNamespace.setModelUnit(namespace);
        return modelNamespace;
    }

    public EList<ElementReference> resolveInModelScope(QualifiedName qualifiedName) {
        return this.getContext(qualifiedName).resolvePathName(qualifiedName.getPathName());
    }

    public ModelNamespaceImpl createValidationContext(Resource validatedResource, Namespace validationContext) {
        return this.registry.createValidationContext(validatedResource.getURI(), validationContext);
    }

    public ModelNamespaceImpl createEmptyValidationContext(Resource validatedResource) {
        return this.registry.createEmptyValidationContext(validatedResource.getURI());
    }

    public boolean deleteValidationContext(Resource validatedResource) {
        return this.registry.deleteValidationContext(validatedResource.getURI());
    }
}

